/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.debug.DebuggerDisplay;
import java.util.Objects;

@DebuggerDisplay(value="{debuggerDisplay(),nq}")
final class CopyPosition {
    private final int row;
    private final int column;

    CopyPosition(int row, int column) {
        assert (row >= 0);
        assert (column >= 0);
        this.row = row;
        this.column = column;
    }

    public static CopyPosition start() {
        return new CopyPosition(0, 0);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public CopyPosition normalize(int endColumn) {
        assert (this.column <= endColumn);
        return this.column == endColumn ? new CopyPosition(this.row + 1, 0) : this;
    }

    private String debuggerDisplay() {
        return this.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CopyPosition)) return false;
        CopyPosition that = (CopyPosition)obj;
        if (!Objects.equals(this.row, that.row)) return false;
        if (!Objects.equals(this.column, that.column)) return false;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.row;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return String.format("[%s, %s]", this.row, this.column);
    }
}

