/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.Set;

final class DistinctByIterator<TSource, TKey>
extends AbstractIterator<TSource> {
    private final IEnumerable<TSource> source;
    private final Func1<TSource, TKey> keySelector;
    private final IEqualityComparer<TKey> comparer;
    private Set<TKey> set;
    private IEnumerator<TSource> enumerator;

    DistinctByIterator(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        this.source = source;
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new DistinctByIterator<TSource, TKey>(this.source, this.keySelector, this.comparer);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                if (!this.enumerator.moveNext()) {
                    this.close();
                    return false;
                }
                TSource element = this.enumerator.current();
                this.set = new Set<TKey>(this.comparer);
                this.set.add(this.keySelector.apply(element));
                this.current = element;
                this.state = 2;
                return true;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource element = this.enumerator.current();
                    if (!this.set.add(this.keySelector.apply(element))) continue;
                    this.current = element;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.set = null;
        }
        super.close();
    }
}

