/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.Index;
import com.bestvike.collections.generic.IList;
import com.bestvike.collections.generic.Queue;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.Count;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.out;

public final class ElementAt {
    private ElementAt() {
    }

    public static <TSource> TSource elementAt(IEnumerable<TSource> source, int index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            out<Boolean> foundRef = out.init();
            Object element = partition._tryGetElementAt(index, foundRef);
            if (((Boolean)foundRef.value).booleanValue()) {
                return (TSource)element;
            }
        } else {
            if (source instanceof IList) {
                IList list = (IList)source;
                return (TSource)list.get(index);
            }
            out elementRef = out.init();
            if (ElementAt.tryGetElement(source, index, elementRef)) {
                return (TSource)elementRef.value;
            }
        }
        ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.index);
        return null;
    }

    public static <TSource> TSource elementAt(IEnumerable<TSource> source, Index index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (!index.isFromEnd()) {
            return ElementAt.elementAt(source, index.getValue());
        }
        out<Integer> countRef = out.init();
        if (Count.tryGetNonEnumeratedCount(source, countRef)) {
            return ElementAt.elementAt(source, (Integer)countRef.value - index.getValue());
        }
        out elementRef = out.init();
        if (!ElementAt.tryGetElementFromEnd(source, index.getValue(), elementRef)) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.index);
        }
        return (TSource)elementRef.value;
    }

    public static <TSource> TSource elementAtOrDefault(IEnumerable<TSource> source, int index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            out<Boolean> foundRef = out.init();
            return (TSource)partition._tryGetElementAt(index, foundRef);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            return index >= 0 && index < list._getCount() ? (TSource)list.get(index) : null;
        }
        out elementRef = out.init();
        ElementAt.tryGetElement(source, index, elementRef);
        return (TSource)elementRef.value;
    }

    public static <TSource> TSource elementAtOrDefault(IEnumerable<TSource> source, Index index) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (!index.isFromEnd()) {
            return ElementAt.elementAtOrDefault(source, index.getValue());
        }
        out<Integer> countRef = out.init();
        if (Count.tryGetNonEnumeratedCount(source, countRef)) {
            return ElementAt.elementAtOrDefault(source, (Integer)countRef.value - index.getValue());
        }
        out elementRef = out.init();
        ElementAt.tryGetElementFromEnd(source, index.getValue(), elementRef);
        return (TSource)elementRef.value;
    }

    private static <TSource> boolean tryGetElement(IEnumerable<TSource> source, int index, out<TSource> element) {
        assert (source != null);
        if (index >= 0) {
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    if (index == 0) {
                        element.value = e.current();
                        boolean bl = true;
                        return bl;
                    }
                    --index;
                }
            }
        }
        element.value = null;
        return false;
    }

    private static <TSource> boolean tryGetElementFromEnd(IEnumerable<TSource> source, int indexFromEnd, out<TSource> element) {
        assert (source != null);
        if (indexFromEnd > 0) {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (e.moveNext()) {
                    Queue<TSource> queue = new Queue<TSource>();
                    queue.enqueue(e.current());
                    while (e.moveNext()) {
                        if (queue.size() == indexFromEnd) {
                            queue.dequeue();
                        }
                        queue.enqueue(e.current());
                    }
                    if (queue.size() == indexFromEnd) {
                        element.value = queue.dequeue();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        element.value = null;
        return false;
    }
}

