/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

final class EnumerableHelpers {
    private static final int MaxArrayLength = 0x7FFFFFC7;

    private EnumerableHelpers() {
    }

    public static <T> void copy(IEnumerable<T> source, Object[] array, int arrayIndex, int count) {
        assert (source != null);
        assert (arrayIndex >= 0);
        assert (count >= 0);
        assert (array != null && array.length - arrayIndex >= count);
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            assert (collection._getCount() == count);
            collection._copyTo(array, arrayIndex);
            return;
        }
        EnumerableHelpers.iterativeCopy(source, array, arrayIndex, count);
    }

    public static <T> void iterativeCopy(IEnumerable<T> source, Object[] array, int arrayIndex, int count) {
        assert (source != null && !(source instanceof ICollection));
        assert (arrayIndex >= 0);
        assert (count >= 0);
        assert (array != null && array.length - arrayIndex >= count);
        int endIndex = arrayIndex + count;
        try (IEnumerator<T> e = source.enumerator();){
            while (e.moveNext()) {
                array[arrayIndex++] = e.current();
            }
        }
        assert (arrayIndex == endIndex);
    }

    public static <T> T[] toArray(IEnumerable<T> source, Class<T> clazz) {
        assert (source != null);
        assert (clazz != null);
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int count = collection._getCount();
            return count == 0 ? ArrayUtils.empty(clazz) : collection._toArray(clazz);
        }
        LargeArrayBuilder<T> builder = new LargeArrayBuilder<T>();
        builder.addRange(source);
        return builder.toArray(clazz);
    }

    public static <T> Object[] toArray(IEnumerable<T> source) {
        assert (source != null);
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int count = collection._getCount();
            return count == 0 ? ArrayUtils.empty() : collection._toArray();
        }
        LargeArrayBuilder<T> builder = new LargeArrayBuilder<T>();
        builder.addRange(source);
        return builder.toArray();
    }

    public static <T> Object[] toArray(IEnumerable<T> source, out<Integer> length) {
        if (source instanceof ICollection) {
            ICollection ic = (ICollection)source;
            int count = ic._getCount();
            if (count != 0) {
                length.value = count;
                return ic._toArray();
            }
        } else {
            try (IEnumerator<T> en = source.enumerator();){
                if (en.moveNext()) {
                    int DefaultCapacity = 4;
                    Object[] arr = new Object[4];
                    arr[0] = en.current();
                    int count = 1;
                    while (en.moveNext()) {
                        if (count == arr.length) {
                            int newLength = count << 1;
                            if (Integer.compareUnsigned(newLength, 0x7FFFFFC7) > 0) {
                                newLength = 0x7FFFFFC7 <= count ? count + 1 : 0x7FFFFFC7;
                            }
                            arr = ArrayUtils.resize(arr, newLength);
                        }
                        arr[count++] = en.current();
                    }
                    length.value = count;
                    Object[] objectArray = arr;
                    return objectArray;
                }
            }
        }
        length.value = 0;
        return ArrayUtils.empty();
    }

    public static <T> List<T> toList(IEnumerable<T> source) {
        assert (source != null);
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int count = collection._getCount();
            return count == 0 ? ListUtils.empty() : collection._toList();
        }
        ArrayList<T> list = new ArrayList<T>();
        try (IEnumerator<T> e = source.enumerator();){
            while (e.moveNext()) {
                list.add(e.current());
            }
        }
        return list;
    }
}

