/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ExceptIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Except {
    private Except() {
    }

    public static <TSource> IEnumerable<TSource> except(IEnumerable<TSource> first, IEnumerable<TSource> second) {
        return Except.except(first, second, null);
    }

    public static <TSource> IEnumerable<TSource> except(IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        return new ExceptIterator<TSource>(first, second, comparer);
    }
}

