/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.Buffer;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class FindIndex {
    private FindIndex() {
    }

    public static <TSource> int findIndex(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            return list._findIndex(predicate);
        }
        int index = 0;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (predicate.apply(e.current())) {
                    int n = index;
                    return n;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <TSource> int findLastIndex(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            return list._findLastIndex(predicate);
        }
        Buffer<TSource> buffer = new Buffer<TSource>(source);
        Object[] array = buffer.items;
        for (int i = buffer.count - 1; i >= 0; --i) {
            if (!predicate.apply(array[i])) continue;
            return i;
        }
        return -1;
    }
}

