/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.IGrouping;
import com.bestvike.linq.adapter.enumerator.ArrayEnumerator;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.debug.DebuggerTypeProxy;
import com.bestvike.linq.debug.GroupingDebugView;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.ArrayUtils;
import java.util.Collection;
import java.util.List;

@DebuggerDisplay(value="Key = {getKey()}")
@DebuggerTypeProxy(value=GroupingDebugView.class)
final class Grouping<TKey, TElement>
implements IGrouping<TKey, TElement>,
IArray<TElement> {
    final TKey key;
    final int hashCode;
    Object[] elements;
    int count;
    Grouping<TKey, TElement> hashNext;
    Grouping<TKey, TElement> next;
    boolean fetched;

    Grouping(TKey key, int hashCode) {
        this.key = key;
        this.hashCode = hashCode;
        this.elements = new Object[1];
    }

    void add(TElement element) {
        if (this.elements.length == this.count) {
            this.elements = ArrayUtils.resize(this.elements, Math.multiplyExact(this.count, 2));
        }
        this.elements[this.count] = element;
        ++this.count;
    }

    public void trim() {
        if (this.elements.length != this.count) {
            this.elements = ArrayUtils.resize(this.elements, this.count);
        }
    }

    @Override
    public IEnumerator<TElement> enumerator() {
        return new ArrayEnumerator(this.elements, 0, this.count);
    }

    @Override
    public TKey getKey() {
        return this.key;
    }

    public Object[] getArray() {
        return this.elements;
    }

    @Override
    public TElement get(int index) {
        if (index < 0 || index >= this.count) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.index);
        }
        return (TElement)this.elements[index];
    }

    @Override
    public int _indexOf(TElement item) {
        return ArrayUtils.indexOf(this.elements, item, 0, this.count);
    }

    @Override
    public int _lastIndexOf(TElement item) {
        return ArrayUtils.lastIndexOf(this.elements, item, this.count - 1, this.count);
    }

    @Override
    public int _findIndex(Predicate1<TElement> match) {
        return ArrayUtils.findIndex(this.elements, 0, this.count, match);
    }

    @Override
    public int _findLastIndex(Predicate1<TElement> match) {
        return ArrayUtils.findLastIndex(this.elements, this.count - 1, this.count, match);
    }

    @Override
    public Collection<TElement> getCollection() {
        return ArrayUtils.toCollection(this.elements, 0, this.count);
    }

    @Override
    public int _getCount() {
        return this.count;
    }

    @Override
    public boolean _contains(TElement item) {
        return ArrayUtils.contains(this.elements, item, 0, this.count);
    }

    @Override
    public void _copyTo(Object[] array, int arrayIndex) {
        System.arraycopy(this.elements, 0, array, arrayIndex, this.count);
    }

    @Override
    public TElement[] _toArray(Class<TElement> clazz) {
        return ArrayUtils.toArray(this.elements, clazz, 0, this.count);
    }

    @Override
    public Object[] _toArray() {
        return ArrayUtils.resize(this.elements, this.count);
    }

    @Override
    public List<TElement> _toList() {
        return ArrayUtils.toList(this.elements, 0, this.count);
    }
}

