/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.EqualityComparer;
import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.collections.generic.IList;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.Buffer;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class IndexOf {
    private IndexOf() {
    }

    public static <TSource> int indexOf(IEnumerable<TSource> source, TSource value) {
        if (source instanceof IList) {
            IList list = (IList)source;
            return list._indexOf(value);
        }
        return IndexOf.indexOf(source, value, null);
    }

    public static <TSource> int indexOf(IEnumerable<TSource> source, TSource value, IEqualityComparer<TSource> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (comparer == null) {
            comparer = EqualityComparer.Default();
        }
        int index = 0;
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (comparer.equals(e.current(), value)) {
                    int n = index;
                    return n;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <TSource> int lastIndexOf(IEnumerable<TSource> source, TSource value) {
        if (source instanceof IList) {
            IList list = (IList)source;
            return list._lastIndexOf(value);
        }
        return IndexOf.lastIndexOf(source, value, null);
    }

    public static <TSource> int lastIndexOf(IEnumerable<TSource> source, TSource value, IEqualityComparer<TSource> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (comparer == null) {
            comparer = EqualityComparer.Default();
        }
        Buffer<TSource> buffer = new Buffer<TSource>(source);
        Object[] array = buffer.items;
        for (int i = buffer.count - 1; i >= 0; --i) {
            if (!comparer.equals(array[i], value)) continue;
            return i;
        }
        return -1;
    }
}

