/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.IntersectIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Intersect {
    private Intersect() {
    }

    public static <TSource> IEnumerable<TSource> intersect(IEnumerable<TSource> first, IEnumerable<TSource> second) {
        return Intersect.intersect(first, second, null);
    }

    public static <TSource> IEnumerable<TSource> intersect(IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        return new IntersectIterator<TSource>(first, second, comparer);
    }
}

