/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.IntersectByIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class IntersectBy {
    private IntersectBy() {
    }

    public static <TSource, TKey> IEnumerable<TSource> intersectBy(IEnumerable<TSource> first, IEnumerable<TKey> second, Func1<TSource, TKey> keySelector) {
        return IntersectBy.intersectBy(first, second, keySelector, null);
    }

    public static <TSource, TKey> IEnumerable<TSource> intersectBy(IEnumerable<TSource> first, IEnumerable<TKey> second, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        return new IntersectByIterator<TSource, TKey>(first, second, keySelector, comparer);
    }
}

