/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.Set;

final class IntersectIterator<TSource>
extends AbstractIterator<TSource> {
    private final IEnumerable<TSource> first;
    private final IEnumerable<TSource> second;
    private final IEqualityComparer<TSource> comparer;
    private Set<TSource> set;
    private IEnumerator<TSource> enumerator;

    IntersectIterator(IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new IntersectIterator<TSource>(this.first, this.second, this.comparer);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.set = new Set<TSource>(this.second, this.comparer);
                this.enumerator = this.first.enumerator();
                this.state = 2;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource item = this.enumerator.current();
                    if (!this.set.remove(item)) continue;
                    this.current = item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.set = null;
        }
        super.close();
    }
}

