/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractOrderedEnumerable;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.out;

public final class Last {
    private Last() {
    }

    public static <TSource> TSource last(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        TSource last = Last.tryGetLast(source, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoElementsException();
        }
        return last;
    }

    public static <TSource> TSource last(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        TSource last = Last.tryGetLast(source, predicate, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoMatchException();
        }
        return last;
    }

    public static <TSource> TSource lastOrDefault(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        return Last.tryGetLast(source, foundRef);
    }

    public static <TSource> TSource lastOrDefault(IEnumerable<TSource> source, TSource defaultValue) {
        out<Boolean> foundRef = out.init();
        TSource last = Last.tryGetLast(source, foundRef);
        return (Boolean)foundRef.value != false ? last : defaultValue;
    }

    public static <TSource> TSource lastOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        return Last.tryGetLast(source, predicate, foundRef);
    }

    public static <TSource> TSource lastOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate, TSource defaultValue) {
        out<Boolean> foundRef = out.init();
        TSource last = Last.tryGetLast(source, predicate, foundRef);
        return (Boolean)foundRef.value != false ? last : defaultValue;
    }

    private static <TSource> TSource tryGetLast(IEnumerable<TSource> source, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return (TSource)partition._tryGetLast(found);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            int count = list._getCount();
            if (count > 0) {
                found.value = true;
                return (TSource)list.get(count - 1);
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (e.moveNext()) {
                    TSource result;
                    do {
                        result = e.current();
                    } while (e.moveNext());
                    found.value = true;
                    TSource TSource = result;
                    return TSource;
                }
            }
        }
        found.value = false;
        return null;
    }

    private static <TSource> TSource tryGetLast(IEnumerable<TSource> source, Predicate1<TSource> predicate, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        if (source instanceof AbstractOrderedEnumerable) {
            AbstractOrderedEnumerable ordered = (AbstractOrderedEnumerable)source;
            return ordered._tryGetLast(predicate, found);
        }
        if (source instanceof IArrayList) {
            IArrayList list = (IArrayList)source;
            for (int i = list._getCount() - 1; i >= 0; --i) {
                Object result = list.get(i);
                if (!predicate.apply(result)) continue;
                found.value = true;
                return (TSource)result;
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    TSource result = e.current();
                    if (!predicate.apply(result)) continue;
                    while (e.moveNext()) {
                        TSource element = e.current();
                        if (!predicate.apply(element)) continue;
                        result = element;
                    }
                    found.value = true;
                    TSource TSource = result;
                    return TSource;
                }
            }
        }
        found.value = false;
        return null;
    }
}

