/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SelectListPartitionIterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {_getCount()}")
final class ListPartition<TSource>
extends Iterator<TSource>
implements IPartition<TSource> {
    private final IArrayList<TSource> source;
    private final int minIndexInclusive;
    private final int maxIndexInclusive;

    ListPartition(IArrayList<TSource> source, int minIndexInclusive, int maxIndexInclusive) {
        assert (source != null);
        assert (minIndexInclusive >= 0);
        assert (minIndexInclusive <= maxIndexInclusive);
        this.source = source;
        this.minIndexInclusive = minIndexInclusive;
        this.maxIndexInclusive = maxIndexInclusive;
    }

    @Override
    public Iterator<TSource> clone() {
        return new ListPartition<TSource>(this.source, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0 && index < this.source._getCount() - this.minIndexInclusive) {
            this.current = this.source.get(this.minIndexInclusive + index);
            ++this.state;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<TSource, TResult> selector) {
        return new SelectListPartitionIterator<TSource, TResult>(this.source, selector, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TSource> _skip(int count) {
        int minIndex = this.minIndexInclusive + count;
        return Integer.compareUnsigned(minIndex, this.maxIndexInclusive) > 0 ? EmptyPartition.instance() : new ListPartition<TSource>(this.source, minIndex, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TSource> _take(int count) {
        int maxIndex = this.minIndexInclusive + count - 1;
        return Integer.compareUnsigned(maxIndex, this.maxIndexInclusive) >= 0 ? this : new ListPartition<TSource>(this.source, this.minIndexInclusive, maxIndex);
    }

    @Override
    public TSource _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0 && index < this.source._getCount() - this.minIndexInclusive) {
            found.value = true;
            return (TSource)this.source.get(this.minIndexInclusive + index);
        }
        found.value = false;
        return null;
    }

    @Override
    public TSource _tryGetFirst(out<Boolean> found) {
        if (this.source._getCount() > this.minIndexInclusive) {
            found.value = true;
            return (TSource)this.source.get(this.minIndexInclusive);
        }
        found.value = false;
        return null;
    }

    @Override
    public TSource _tryGetLast(out<Boolean> found) {
        int lastIndex = this.source._getCount() - 1;
        if (lastIndex >= this.minIndexInclusive) {
            found.value = true;
            return (TSource)this.source.get(Math.min(lastIndex, this.maxIndexInclusive));
        }
        found.value = false;
        return null;
    }

    private int _getCount() {
        int count = this.source._getCount();
        if (count <= this.minIndexInclusive) {
            return 0;
        }
        return Math.min(count - 1, this.maxIndexInclusive) - this.minIndexInclusive + 1;
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        int count = this._getCount();
        if (count == 0) {
            return ArrayUtils.empty(clazz);
        }
        TSource[] array = ArrayUtils.newInstance(clazz, count);
        int i = 0;
        int curIdx = this.minIndexInclusive;
        while (i != array.length) {
            array[i] = this.source.get(curIdx);
            ++i;
            ++curIdx;
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        int count = this._getCount();
        if (count == 0) {
            return ArrayUtils.empty();
        }
        Object[] array = new Object[count];
        int i = 0;
        int curIdx = this.minIndexInclusive;
        while (i != array.length) {
            array[i] = this.source.get(curIdx);
            ++i;
            ++curIdx;
        }
        return array;
    }

    @Override
    public List<TSource> _toList() {
        int count = this._getCount();
        if (count == 0) {
            return ListUtils.empty();
        }
        ArrayList list = new ArrayList(count);
        int end = this.minIndexInclusive + count;
        for (int i = this.minIndexInclusive; i != end; ++i) {
            list.add(this.source.get(i));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return this._getCount();
    }
}

