/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Comparer;
import com.bestvike.function.DecimalFunc1;
import com.bestvike.function.DoubleFunc1;
import com.bestvike.function.FloatFunc1;
import com.bestvike.function.Func1;
import com.bestvike.function.IntFunc1;
import com.bestvike.function.LongFunc1;
import com.bestvike.function.NullableDecimalFunc1;
import com.bestvike.function.NullableDoubleFunc1;
import com.bestvike.function.NullableFloatFunc1;
import com.bestvike.function.NullableIntFunc1;
import com.bestvike.function.NullableLongFunc1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.math.BigDecimal;
import java.util.Comparator;

public final class Max {
    private Max() {
    }

    public static int maxInt(IEnumerable<Integer> source) {
        int value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<Integer> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current();
            while (e.moveNext()) {
                int x = e.current();
                if (x <= value) continue;
                value = x;
            }
        }
        return value;
    }

    public static Integer maxIntNull(IEnumerable<Integer> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        Integer value = null;
        try (IEnumerator<Integer> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Integer n = value;
                return n;
            } while ((value = e.current()) == null);
            while (e.moveNext()) {
                Integer cur = e.current();
                if (cur == null || cur <= value) continue;
                value = cur;
            }
        }
        return value;
    }

    public static long maxLong(IEnumerable<Long> source) {
        long value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<Long> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current();
            while (e.moveNext()) {
                long x = e.current();
                if (x <= value) continue;
                value = x;
            }
        }
        return value;
    }

    public static Long maxLongNull(IEnumerable<Long> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        Long value = null;
        try (IEnumerator<Long> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Long l = value;
                return l;
            } while ((value = e.current()) == null);
            while (e.moveNext()) {
                Long cur = e.current();
                if (cur == null || cur <= value) continue;
                value = cur;
            }
        }
        return value;
    }

    public static float maxFloat(IEnumerable<Float> source) {
        float value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<Float> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current().floatValue();
            while (Float.isNaN(value)) {
                if (!e.moveNext()) {
                    float f = value;
                    return f;
                }
                value = e.current().floatValue();
            }
            while (e.moveNext()) {
                float x = e.current().floatValue();
                if (!(x > value)) continue;
                value = x;
            }
        }
        return value;
    }

    public static Float maxFloatNull(IEnumerable<Float> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        Float value = null;
        try (IEnumerator<Float> e = source.enumerator();){
            Float cur;
            do {
                if (e.moveNext()) continue;
                Float f = value;
                return f;
            } while ((value = e.current()) == null);
            while (Float.isNaN(value.floatValue())) {
                if (!e.moveNext()) {
                    Float f = value;
                    return f;
                }
                cur = e.current();
                if (cur == null) continue;
                value = cur;
            }
            while (e.moveNext()) {
                cur = e.current();
                if (cur == null || !(cur.floatValue() > value.floatValue())) continue;
                value = cur;
            }
        }
        return value;
    }

    public static double maxDouble(IEnumerable<Double> source) {
        double value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<Double> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current();
            while (Double.isNaN(value)) {
                if (!e.moveNext()) {
                    double d = value;
                    return d;
                }
                value = e.current();
            }
            while (e.moveNext()) {
                double x = e.current();
                if (!(x > value)) continue;
                value = x;
            }
        }
        return value;
    }

    public static Double maxDoubleNull(IEnumerable<Double> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        Double value = null;
        try (IEnumerator<Double> e = source.enumerator();){
            Double cur;
            do {
                if (e.moveNext()) continue;
                Double d = value;
                return d;
            } while ((value = e.current()) == null);
            while (Double.isNaN(value)) {
                if (!e.moveNext()) {
                    Double d = value;
                    return d;
                }
                cur = e.current();
                if (cur == null) continue;
                value = cur;
            }
            while (e.moveNext()) {
                cur = e.current();
                if (cur == null || !(cur > value)) continue;
                value = cur;
            }
        }
        return value;
    }

    public static BigDecimal maxDecimal(IEnumerable<BigDecimal> source) {
        BigDecimal value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        try (IEnumerator<BigDecimal> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((value = e.current()) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                BigDecimal x = e.current();
                if (x.compareTo(value) <= 0) continue;
                value = x;
            }
        }
        return value;
    }

    public static BigDecimal maxDecimalNull(IEnumerable<BigDecimal> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        BigDecimal value = null;
        try (IEnumerator<BigDecimal> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                BigDecimal bigDecimal = value;
                return bigDecimal;
            } while ((value = e.current()) == null);
            while (e.moveNext()) {
                BigDecimal cur = e.current();
                if (cur == null || cur.compareTo(value) <= 0) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource> TSource max(IEnumerable<TSource> source) {
        return Max.max(source, (Comparator)null);
    }

    public static <TSource> TSource max(IEnumerable<TSource> source, Comparator<TSource> comparer) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (comparer == null) {
            comparer = Comparer.Default();
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((value = e.current()) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                TSource x = e.current();
                if (x == null) {
                    ThrowHelper.throwNullPointerException();
                }
                if (comparer.compare(x, value) <= 0) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> TSource maxNull(IEnumerable<TSource> source) {
        return Max.maxNull(source, (Comparator)null);
    }

    public static <TSource> TSource maxNull(IEnumerable<TSource> source, Comparator<TSource> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (comparer == null) {
            comparer = Comparer.Default();
        }
        Object value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Object t = value;
                return (TSource)t;
            } while ((value = (Object)e.current()) == null);
            while (e.moveNext()) {
                TSource cur = e.current();
                if (cur == null || comparer.compare(cur, value) <= 0) continue;
                value = cur;
            }
        }
        return (TSource)value;
    }

    public static <TSource> int maxInt(IEnumerable<TSource> source, IntFunc1<TSource> selector) {
        int value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = selector.apply(e.current());
            while (e.moveNext()) {
                int x = selector.apply(e.current());
                if (x <= value) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> Integer maxIntNull(IEnumerable<TSource> source, NullableIntFunc1<TSource> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        Integer value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Integer n = value;
                return n;
            } while ((value = selector.apply(e.current())) == null);
            while (e.moveNext()) {
                Integer cur = selector.apply(e.current());
                if (cur == null || cur <= value) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource> long maxLong(IEnumerable<TSource> source, LongFunc1<TSource> selector) {
        long value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = selector.apply(e.current());
            while (e.moveNext()) {
                long x = selector.apply(e.current());
                if (x <= value) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> Long maxLongNull(IEnumerable<TSource> source, NullableLongFunc1<TSource> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        Long value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Long l = value;
                return l;
            } while ((value = selector.apply(e.current())) == null);
            while (e.moveNext()) {
                Long cur = selector.apply(e.current());
                if (cur == null || cur <= value) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource> float maxFloat(IEnumerable<TSource> source, FloatFunc1<TSource> selector) {
        float value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = selector.apply(e.current());
            while (Float.isNaN(value)) {
                if (!e.moveNext()) {
                    float f = value;
                    return f;
                }
                value = selector.apply(e.current());
            }
            while (e.moveNext()) {
                float x = selector.apply(e.current());
                if (!(x > value)) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> Float maxFloatNull(IEnumerable<TSource> source, NullableFloatFunc1<TSource> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        Float value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            Float cur;
            do {
                if (e.moveNext()) continue;
                Float f = value;
                return f;
            } while ((value = selector.apply(e.current())) == null);
            while (Float.isNaN(value.floatValue())) {
                if (!e.moveNext()) {
                    Float f = value;
                    return f;
                }
                cur = selector.apply(e.current());
                if (cur == null) continue;
                value = cur;
            }
            while (e.moveNext()) {
                cur = selector.apply(e.current());
                if (cur == null || !(cur.floatValue() > value.floatValue())) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource> double maxDouble(IEnumerable<TSource> source, DoubleFunc1<TSource> selector) {
        double value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = selector.apply(e.current());
            while (Double.isNaN(value)) {
                if (!e.moveNext()) {
                    double d = value;
                    return d;
                }
                value = selector.apply(e.current());
            }
            while (e.moveNext()) {
                double x = selector.apply(e.current());
                if (!(x > value)) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> Double maxDoubleNull(IEnumerable<TSource> source, NullableDoubleFunc1<TSource> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        Double value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            Double cur;
            do {
                if (e.moveNext()) continue;
                Double d = value;
                return d;
            } while ((value = selector.apply(e.current())) == null);
            while (Double.isNaN(value)) {
                if (!e.moveNext()) {
                    Double d = value;
                    return d;
                }
                cur = selector.apply(e.current());
                if (cur == null) continue;
                value = cur;
            }
            while (e.moveNext()) {
                cur = selector.apply(e.current());
                if (cur == null || !(cur > value)) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource> BigDecimal maxDecimal(IEnumerable<TSource> source, DecimalFunc1<TSource> selector) {
        BigDecimal value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((value = selector.apply(e.current())) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                BigDecimal x = selector.apply(e.current());
                if (x.compareTo(value) <= 0) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource> BigDecimal maxDecimalNull(IEnumerable<TSource> source, NullableDecimalFunc1<TSource> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        BigDecimal value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                BigDecimal bigDecimal = value;
                return bigDecimal;
            } while ((value = selector.apply(e.current())) == null);
            while (e.moveNext()) {
                BigDecimal cur = selector.apply(e.current());
                if (cur == null || cur.compareTo(value) <= 0) continue;
                value = cur;
            }
        }
        return value;
    }

    public static <TSource, TResult> TResult max(IEnumerable<TSource> source, Func1<TSource, TResult> selector) {
        return Max.max(source, selector, null);
    }

    public static <TSource, TResult> TResult max(IEnumerable<TSource> source, Func1<TSource, TResult> selector, Comparator<TResult> comparer) {
        TResult value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        if (comparer == null) {
            comparer = Comparer.Default();
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((value = selector.apply(e.current())) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                TResult x = selector.apply(e.current());
                if (x == null) {
                    ThrowHelper.throwNullPointerException();
                }
                if (comparer.compare(x, value) <= 0) continue;
                value = x;
            }
        }
        return value;
    }

    public static <TSource, TResult> TResult maxNull(IEnumerable<TSource> source, Func1<TSource, TResult> selector) {
        return Max.maxNull(source, selector, null);
    }

    public static <TSource, TResult> TResult maxNull(IEnumerable<TSource> source, Func1<TSource, TResult> selector, Comparator<TResult> comparer) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        if (comparer == null) {
            comparer = Comparer.Default();
        }
        Object value = null;
        try (IEnumerator<TSource> e = source.enumerator();){
            do {
                if (e.moveNext()) continue;
                Object t = value;
                return (TResult)t;
            } while ((value = (Object)selector.apply(e.current())) == null);
            while (e.moveNext()) {
                TResult cur = selector.apply(e.current());
                if (cur == null || comparer.compare(cur, value) <= 0) continue;
                value = cur;
            }
        }
        return (TResult)value;
    }
}

