/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;

final class OfTypeIterator<TResult>
extends AbstractIterator<TResult> {
    private final IEnumerable<?> source;
    private final Class<TResult> clazz;
    private IEnumerator<?> enumerator;

    OfTypeIterator(IEnumerable<?> source, Class<TResult> clazz) {
        this.source = source;
        this.clazz = clazz;
    }

    @Override
    public AbstractIterator<TResult> clone() {
        return new OfTypeIterator<TResult>(this.source, this.clazz);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    Object item = this.enumerator.current();
                    if (!this.clazz.isInstance(item)) continue;
                    this.current = item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }
}

