/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Comparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.AbstractCachingComparer;
import com.bestvike.linq.enumerable.AbstractEnumerableSorter;
import com.bestvike.linq.enumerable.AbstractOrderedEnumerable;
import com.bestvike.linq.enumerable.CachingComparer;
import com.bestvike.linq.enumerable.CachingComparerWithChild;
import com.bestvike.linq.enumerable.EnumerableSorter;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.Comparator;

final class OrderedEnumerable<TElement, TKey>
extends AbstractOrderedEnumerable<TElement> {
    private final AbstractOrderedEnumerable<TElement> parent;
    private final Func1<TElement, TKey> keySelector;
    private final Comparator<TKey> comparer;
    private final boolean descending;

    OrderedEnumerable(IEnumerable<TElement> source, Func1<TElement, TKey> keySelector, Comparator<TKey> comparer, boolean descending, AbstractOrderedEnumerable<TElement> parent) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        this.source = source;
        this.parent = parent;
        this.keySelector = keySelector;
        this.comparer = comparer == null ? Comparer.Default() : comparer;
        this.descending = descending;
    }

    @Override
    protected AbstractEnumerableSorter<TElement> getEnumerableSorter(AbstractEnumerableSorter<TElement> next) {
        AbstractEnumerableSorter sorter = new EnumerableSorter<TElement, TKey>(this.keySelector, this.comparer, this.descending, next);
        if (this.parent != null) {
            sorter = this.parent.getEnumerableSorter(sorter);
        }
        return sorter;
    }

    @Override
    protected AbstractCachingComparer<TElement> getComparer(AbstractCachingComparer<TElement> childComparer) {
        CachingComparer<TElement, TKey> cmp = childComparer == null ? new CachingComparer<TElement, TKey>(this.keySelector, this.comparer, this.descending) : new CachingComparerWithChild<TElement, TKey>(this.keySelector, this.comparer, this.descending, childComparer);
        return this.parent != null ? this.parent.getComparer(cmp) : cmp;
    }
}

