/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.SplitInternal;

final class ProbabilisticMap {
    private static final int PROBABILISTICMAP_BLOCK_INDEX_MASK = 7;
    private static final int PROBABILISTICMAP_BLOCK_INDEX_SHIFT = 3;
    private static final int PROBABILISTICMAP_SIZE = 8;
    private final char[] chars;
    private final int[] charMap;

    ProbabilisticMap(char[] chars) {
        int[] charMap = new int[8];
        boolean hasAscii = false;
        for (int n : chars) {
            ProbabilisticMap.setCharBit(charMap, (byte)n);
            if ((n >>>= 8) == 0) {
                hasAscii = true;
                continue;
            }
            ProbabilisticMap.setCharBit(charMap, (byte)n);
        }
        if (hasAscii) {
            charMap[0] = charMap[0] | 1;
        }
        this.chars = chars;
        this.charMap = charMap;
    }

    private static void setCharBit(int[] charMap, byte value) {
        int n = value & 7;
        charMap[n] = charMap[n] | 1 << (value >>> 3);
    }

    private static boolean isCharBitSet(int[] charMap, byte value) {
        return (charMap[value & 7] & 1 << (value >>> 3)) != 0;
    }

    public boolean contains(char value) {
        return ProbabilisticMap.isCharBitSet(this.charMap, (byte)value) && ProbabilisticMap.isCharBitSet(this.charMap, (byte)(value >> 8)) && SplitInternal.contains(this.chars, value);
    }
}

