/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.RangeIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Range {
    private Range() {
    }

    public static IEnumerable<Integer> range(int start, int count) {
        long max = (long)start + (long)count - 1L;
        if (count < 0 || max > Integer.MAX_VALUE) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.count);
        }
        if (count == 0) {
            return EmptyPartition.instance();
        }
        return new RangeIterator(start, count);
    }
}

