/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SelectRangeIterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {countForDebugger()}")
final class RangeIterator
extends Iterator<Integer>
implements IPartition<Integer> {
    private final int start;
    private final int end;

    RangeIterator(int start, int count) {
        assert (count > 0);
        this.start = start;
        this.end = start + count;
    }

    private int countForDebugger() {
        return this.end - this.start;
    }

    @Override
    public Iterator<Integer> clone() {
        return new RangeIterator(this.start, this.end - this.start);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                assert (this.start != this.end);
                this.current = this.start;
                this.state = 2;
                return true;
            }
            case 2: {
                RangeIterator rangeIterator = this;
                rangeIterator.current = (Integer)rangeIterator.current + 1;
                if ((Integer)rangeIterator.current == this.end) {
                    this.close();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<Integer, TResult> selector) {
        return new SelectRangeIterator<TResult>(this.start, this.end, selector);
    }

    public Integer[] _toArray(Class<Integer> clazz) {
        Integer[] array = ArrayUtils.newInstance(clazz, this.end - this.start);
        int cur = this.start;
        for (int i = 0; i != array.length; ++i) {
            array[i] = cur;
            ++cur;
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        Object[] array = new Object[this.end - this.start];
        int cur = this.start;
        for (int i = 0; i != array.length; ++i) {
            array[i] = cur;
            ++cur;
        }
        return array;
    }

    @Override
    public List<Integer> _toList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.end - this.start);
        for (int cur = this.start; cur != this.end; ++cur) {
            list.add(cur);
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return this.end - this.start;
    }

    @Override
    public IPartition<Integer> _skip(int count) {
        assert (count > 0);
        return count >= this.end - this.start ? EmptyPartition.instance() : new RangeIterator(this.start + count, this.end - this.start - count);
    }

    @Override
    public IPartition<Integer> _take(int count) {
        assert (count > 0);
        return count >= this.end - this.start ? this : new RangeIterator(this.start, count);
    }

    @Override
    public Integer _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.end - this.start) < 0) {
            found.value = true;
            return this.start + index;
        }
        found.value = false;
        return null;
    }

    @Override
    public Integer _tryGetFirst(out<Boolean> found) {
        found.value = true;
        return this.start;
    }

    @Override
    public Integer _tryGetLast(out<Boolean> found) {
        found.value = true;
        return this.end - 1;
    }
}

