/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.RepeatIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Repeat {
    private Repeat() {
    }

    public static <TResult> IEnumerable<TResult> repeat(TResult element, int count) {
        if (count < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.count);
        }
        if (count == 0) {
            return EmptyPartition.instance();
        }
        return new RepeatIterator<TResult>(element, count);
    }
}

