/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SelectRepeatIterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {count}")
final class RepeatIterator<TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final int count;

    RepeatIterator(TResult element, int count) {
        assert (count > 0);
        this.current = element;
        this.count = count;
    }

    @Override
    public Iterator<TResult> clone() {
        return new RepeatIterator<Object>(this.current, this.count);
    }

    @Override
    public boolean moveNext() {
        int sent = this.state - 1;
        if (sent >= 0 && sent != this.count) {
            ++this.state;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.state = -1;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectRepeatIterator<Object, TResult2>(this.current, this.count, selector);
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        TResult[] array = ArrayUtils.newInstance(clazz, this.count);
        if (this.current != null) {
            ArrayUtils.fill(array, this.current);
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        Object[] array = new Object[this.count];
        if (this.current != null) {
            ArrayUtils.fill(array, this.current);
        }
        return array;
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<Object> list = new ArrayList<Object>(this.count);
        for (int i = 0; i != this.count; ++i) {
            list.add(this.current);
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return this.count;
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        return count >= this.count ? EmptyPartition.instance() : new RepeatIterator<Object>(this.current, this.count - count);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        return count >= this.count ? this : new RepeatIterator<Object>(this.current, count);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.count) < 0) {
            found.value = true;
            return (TResult)this.current;
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        found.value = true;
        return (TResult)this.current;
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        found.value = true;
        return (TResult)this.current;
    }
}

