/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Buffer;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.ToCollection;
import com.bestvike.linq.util.ArrayUtils;
import java.util.Collections;
import java.util.List;

final class ReverseIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    private final IEnumerable<TSource> source;
    private Object[] buffer;

    ReverseIterator(IEnumerable<TSource> source) {
        assert (source != null);
        this.source = source;
    }

    @Override
    public Iterator<TSource> clone() {
        return new ReverseIterator<TSource>(this.source);
    }

    @Override
    public boolean moveNext() {
        if (this.state - 2 <= -2) {
            assert (this.state == -1 || this.state == 0);
            this.close();
            return false;
        }
        switch (this.state) {
            case 1: {
                Buffer<TSource> buffer = new Buffer<TSource>(this.source);
                this.buffer = buffer.items;
                this.state = buffer.count + 2;
            }
        }
        int index = this.state - 3;
        if (index != -1) {
            this.current = this.buffer[index];
            --this.state;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.buffer = null;
        super.close();
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        TSource[] array = this.source.toArray(clazz);
        ArrayUtils.reverse(array);
        return array;
    }

    @Override
    public Object[] _toArray() {
        Object[] array = ToCollection.toArray(this.source);
        ArrayUtils.reverse(array);
        return array;
    }

    @Override
    public List<TSource> _toList() {
        List<TSource> list = this.source.toList();
        Collections.reverse(list);
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            if (this.source instanceof ICollection) {
                ICollection col = (ICollection)this.source;
                return col._getCount();
            }
            if (this.source instanceof IIListProvider) {
                IIListProvider listProv = (IIListProvider)this.source;
                return listProv._getCount(true);
            }
            return -1;
        }
        return this.source.count();
    }
}

