/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.function.Func2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.Grouping;
import com.bestvike.linq.enumerable.Lookup;

final class RightJoinIterator<TOuter, TInner, TKey, TResult>
extends AbstractIterator<TResult> {
    private final IEnumerable<TOuter> outer;
    private final IEnumerable<TInner> inner;
    private final Func1<TOuter, TKey> outerKeySelector;
    private final Func1<TInner, TKey> innerKeySelector;
    private final TOuter defaultOuter;
    private final Func2<TOuter, TInner, TResult> resultSelector;
    private final IEqualityComparer<TKey> comparer;
    private IEnumerator<TInner> innerEnumerator;
    private Lookup<TKey, TOuter> lookup;
    private TInner item;
    private Grouping<TKey, TOuter> g;
    private int index;

    RightJoinIterator(IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func1<TOuter, TKey> outerKeySelector, Func1<TInner, TKey> innerKeySelector, TOuter defaultOuter, Func2<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer) {
        this.outer = outer;
        this.inner = inner;
        this.outerKeySelector = outerKeySelector;
        this.innerKeySelector = innerKeySelector;
        this.defaultOuter = defaultOuter;
        this.resultSelector = resultSelector;
        this.comparer = comparer;
    }

    @Override
    public AbstractIterator<TResult> clone() {
        return new RightJoinIterator<TOuter, TInner, TKey, TResult>(this.outer, this.inner, this.outerKeySelector, this.innerKeySelector, this.defaultOuter, this.resultSelector, this.comparer);
    }

    @Override
    public boolean moveNext() {
        block6: while (true) {
            switch (this.state) {
                case 1: {
                    this.innerEnumerator = this.inner.enumerator();
                    if (!this.innerEnumerator.moveNext()) {
                        this.close();
                        return false;
                    }
                    this.lookup = Lookup.createForJoin(this.outer, this.outerKeySelector, this.comparer);
                    this.state = 2;
                }
                case 2: {
                    this.item = this.innerEnumerator.current();
                    this.g = this.lookup.fetchGrouping(this.innerKeySelector.apply(this.item));
                    if (this.g == null) {
                        this.current = this.resultSelector.apply(this.defaultOuter, this.item);
                        this.state = 3;
                        return true;
                    }
                    this.index = -1;
                    this.state = 4;
                    continue block6;
                }
                case 3: {
                    if (!this.innerEnumerator.moveNext()) {
                        this.close();
                        return false;
                    }
                    this.state = 2;
                    continue block6;
                }
                case 4: {
                    ++this.index;
                    if (this.index < this.g._getCount()) {
                        this.current = this.resultSelector.apply(this.g.get(this.index), this.item);
                        return true;
                    }
                    this.state = 3;
                    continue block6;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.innerEnumerator != null) {
            this.innerEnumerator.close();
            this.innerEnumerator = null;
            this.lookup = null;
            this.item = null;
            this.g = null;
        }
        super.close();
    }
}

