/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RunOnceLinkedList<TSource>
implements IList<TSource> {
    private final IList<TSource> source;
    private final Set<Integer> called = new HashSet<Integer>();

    RunOnceLinkedList(IList<TSource> source) {
        this.source = source;
    }

    private void assertAll() {
        if (!this.called.isEmpty()) {
            ThrowHelper.throwRepeatInvokeException();
        }
        this.called.add(-1);
    }

    private void assertIndex(int index) {
        if (this.called.contains(-1)) {
            ThrowHelper.throwRepeatInvokeException();
        }
        if (!this.called.add(index)) {
            ThrowHelper.throwRepeatInvokeException();
        }
    }

    @Override
    public IEnumerator<TSource> enumerator() {
        this.assertAll();
        return this.source.enumerator();
    }

    @Override
    public TSource get(int index) {
        this.assertIndex(index);
        return this.source.get(index);
    }

    @Override
    public int _indexOf(TSource item) {
        this.assertAll();
        return this.source._indexOf(item);
    }

    @Override
    public int _lastIndexOf(TSource item) {
        this.assertAll();
        return this.source._lastIndexOf(item);
    }

    @Override
    public int _findIndex(Predicate1<TSource> match) {
        this.assertAll();
        return this.source._findIndex(match);
    }

    @Override
    public int _findLastIndex(Predicate1<TSource> match) {
        this.assertAll();
        return this.source._findLastIndex(match);
    }

    @Override
    public Collection<TSource> getCollection() {
        this.assertAll();
        return this.source.getCollection();
    }

    @Override
    public int _getCount() {
        return this.source._getCount();
    }

    @Override
    public boolean _contains(TSource item) {
        this.assertAll();
        return this.source._contains(item);
    }

    @Override
    public void _copyTo(Object[] array, int arrayIndex) {
        this.assertAll();
        this.source._copyTo(array, arrayIndex);
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        this.assertAll();
        return this.source._toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        this.assertAll();
        return this.source._toArray();
    }

    @Override
    public List<TSource> _toList() {
        this.assertAll();
        return this.source._toList();
    }
}

