/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.Func1;
import com.bestvike.function.IndexFunc2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SelectArrayIterator;
import com.bestvike.linq.enumerable.SelectEnumerableIterator;
import com.bestvike.linq.enumerable.SelectIListIterator;
import com.bestvike.linq.enumerable.SelectIPartitionIterator;
import com.bestvike.linq.enumerable.SelectIterator;
import com.bestvike.linq.enumerable.SelectListIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Select {
    private Select() {
    }

    public static <TSource, TResult> IEnumerable<TResult> select(IEnumerable<TSource> source, Func1<TSource, TResult> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        if (source instanceof Iterator) {
            Iterator iterator = (Iterator)source;
            return iterator._select(selector);
        }
        if (source instanceof IList) {
            if (source instanceof IArray) {
                IArray array = (IArray)source;
                return array._getCount() == 0 ? EmptyPartition.instance() : new SelectArrayIterator<TSource, TResult>(array, selector);
            }
            if (source instanceof IArrayList) {
                IArrayList list = (IArrayList)source;
                return new SelectListIterator<TSource, TResult>(list, selector);
            }
            IList ilist = (IList)source;
            return new SelectIListIterator<TSource, TResult>(ilist, selector);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return new SelectIPartitionIterator<TSource, TResult>(partition, selector);
        }
        return new SelectEnumerableIterator<TSource, TResult>(source, selector);
    }

    public static <TSource, TResult> IEnumerable<TResult> select(IEnumerable<TSource> source, IndexFunc2<TSource, TResult> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        return new SelectIterator<TSource, TResult>(source, selector);
    }
}

