/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {_getCount()}")
final class SelectIListPartitionIterator<TSource, TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final IList<TSource> source;
    private final Func1<TSource, TResult> selector;
    private final int minIndexInclusive;
    private final int maxIndexInclusive;
    private IEnumerator<TSource> enumerator;

    SelectIListPartitionIterator(IList<TSource> source, Func1<TSource, TResult> selector, int minIndexInclusive, int maxIndexInclusive) {
        assert (source != null);
        assert (!(source instanceof IArrayList)) : String.format("The caller needs to check for %s.", IArrayList.class.getSimpleName());
        assert (selector != null);
        assert (minIndexInclusive >= 0);
        assert (minIndexInclusive <= maxIndexInclusive);
        this.source = source;
        this.selector = selector;
        this.minIndexInclusive = minIndexInclusive;
        this.maxIndexInclusive = maxIndexInclusive;
    }

    private static <TSource> boolean skipBefore(int index, IEnumerator<TSource> en) {
        return SelectIListPartitionIterator.skipAndCount(index, en) == index;
    }

    private static <TSource> int skipAndCount(int index, IEnumerator<TSource> en) {
        assert (index >= 0);
        return (int)SelectIListPartitionIterator.skipAndCount((long)index, en);
    }

    private static <TSource> long skipAndCount(long index, IEnumerator<TSource> en) {
        assert (en != null);
        for (long i = 0L; i < index; ++i) {
            if (en.moveNext()) continue;
            return i;
        }
        return index;
    }

    private int getLimit() {
        return this.maxIndexInclusive + 1 - this.minIndexInclusive;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectIListPartitionIterator<TSource, TResult>(this.source, this.selector, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public boolean moveNext() {
        int taken = this.state - 3;
        if (taken < -2) {
            this.close();
            return false;
        }
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                if (!this.skipBeforeFirst(this.enumerator)) break;
                this.state = 3;
            }
            default: {
                if (taken >= this.getLimit() || !this.enumerator.moveNext()) break;
                ++this.state;
                this.current = this.selector.apply(this.enumerator.current());
                return true;
            }
        }
        this.close();
        return false;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectIListPartitionIterator<TSource, TResult2>(this.source, Utilities.combineSelectors(this.selector, selector), this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        int minIndex = this.minIndexInclusive + count;
        return Integer.compareUnsigned(minIndex, this.maxIndexInclusive) > 0 ? EmptyPartition.instance() : new SelectIListPartitionIterator<TSource, TResult>(this.source, this.selector, minIndex, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        int maxIndex = this.minIndexInclusive + count - 1;
        return Integer.compareUnsigned(maxIndex, this.maxIndexInclusive) >= 0 ? this : new SelectIListPartitionIterator<TSource, TResult>(this.source, this.selector, this.minIndexInclusive, maxIndex);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0 && index < this.source._getCount() - this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(this.minIndexInclusive + index));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        if (this.source._getCount() > this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(this.minIndexInclusive));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        int lastIndex = this.source._getCount() - 1;
        if (lastIndex >= this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(Math.min(lastIndex, this.maxIndexInclusive)));
        }
        found.value = false;
        return null;
    }

    private int _getCount() {
        int count = this.source._getCount();
        if (count <= this.minIndexInclusive) {
            return 0;
        }
        return Math.min(count - 1, this.maxIndexInclusive) - this.minIndexInclusive + 1;
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        try (IEnumerator en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int limit = this.getLimit();
                int remaining = limit - 1;
                LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>(limit);
                do {
                    builder.add(this.selector.apply(en.current()));
                } while (--remaining >= 0 && en.moveNext());
                T[] TArray = builder.toArray(clazz);
                return TArray;
            }
        }
        return ArrayUtils.empty(clazz);
    }

    @Override
    public Object[] _toArray() {
        try (IEnumerator en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int limit = this.getLimit();
                int remaining = limit - 1;
                LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>(limit);
                do {
                    builder.add(this.selector.apply(en.current()));
                } while (--remaining >= 0 && en.moveNext());
                Object[] objectArray = builder.toArray();
                return objectArray;
            }
        }
        return ArrayUtils.empty();
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list = new ArrayList<TResult>();
        try (IEnumerator en = this.source.enumerator();){
            if (this.skipBeforeFirst(en) && en.moveNext()) {
                int remaining = this.getLimit() - 1;
                do {
                    list.add(this.selector.apply(en.current()));
                } while (--remaining >= 0 && en.moveNext());
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        int count = this._getCount();
        if (!onlyIfCheap) {
            try (IEnumerator en = this.source.enumerator();){
                if (this.skipBeforeFirst(en) && en.moveNext()) {
                    int remaining = count - 1;
                    do {
                        this.selector.apply(en.current());
                    } while (--remaining >= 0 && en.moveNext());
                }
            }
        }
        return count;
    }

    private boolean skipBeforeFirst(IEnumerator<TSource> en) {
        return SelectIListPartitionIterator.skipBefore(this.minIndexInclusive, en);
    }
}

