/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

final class SelectIPartitionIterator<TSource, TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final IPartition<TSource> source;
    private final Func1<TSource, TResult> selector;
    private IEnumerator<TSource> enumerator;

    SelectIPartitionIterator(IPartition<TSource> source, Func1<TSource, TResult> selector) {
        assert (source != null);
        assert (selector != null);
        this.source = source;
        this.selector = selector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectIPartitionIterator<TSource, TResult>(this.source, this.selector);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                if (this.enumerator.moveNext()) {
                    this.current = this.selector.apply(this.enumerator.current());
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectIPartitionIterator<TSource, TResult2>(this.source, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        return new SelectIPartitionIterator<TSource, TResult>(this.source._skip(count), this.selector);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        return new SelectIPartitionIterator<TSource, TResult>(this.source._take(count), this.selector);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        TSource input = this.source._tryGetElementAt(index, found);
        return (Boolean)found.value != false ? (TResult)this.selector.apply(input) : null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        TSource input = this.source._tryGetFirst(found);
        return (Boolean)found.value != false ? (TResult)this.selector.apply(input) : null;
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        TSource input = this.source._tryGetLast(found);
        return (Boolean)found.value != false ? (TResult)this.selector.apply(input) : null;
    }

    private TResult[] lazyToArray(Class<TResult> clazz) {
        assert (this.source._getCount(true) == -1);
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>();
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                builder.add(this.selector.apply(e.current()));
            }
        }
        return builder.toArray(clazz);
    }

    private Object[] lazyToArray() {
        assert (this.source._getCount(true) == -1);
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>();
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                builder.add(this.selector.apply(e.current()));
            }
        }
        return builder.toArray();
    }

    private TResult[] preallocatingToArray(Class<TResult> clazz, int count) {
        assert (count > 0);
        assert (count == this.source._getCount(true));
        TResult[] array = ArrayUtils.newInstance(clazz, count);
        int index = 0;
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                array[index] = this.selector.apply(e.current());
                ++index;
            }
        }
        return array;
    }

    private Object[] preallocatingToArray(int count) {
        assert (count > 0);
        assert (count == this.source._getCount(true));
        Object[] array = new Object[count];
        int index = 0;
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                array[index] = this.selector.apply(e.current());
                ++index;
            }
        }
        return array;
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        int count = this.source._getCount(true);
        switch (count) {
            case -1: {
                return this.lazyToArray(clazz);
            }
            case 0: {
                return ArrayUtils.empty(clazz);
            }
        }
        return this.preallocatingToArray(clazz, count);
    }

    @Override
    public Object[] _toArray() {
        int count = this.source._getCount(true);
        switch (count) {
            case -1: {
                return this.lazyToArray();
            }
            case 0: {
                return ArrayUtils.empty();
            }
        }
        return this.preallocatingToArray(count);
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list;
        int count = this.source._getCount(true);
        switch (count) {
            case -1: {
                list = new ArrayList<TResult>();
                break;
            }
            case 0: {
                return ListUtils.empty();
            }
            default: {
                list = new ArrayList(count);
            }
        }
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                list.add(this.selector.apply(e.current()));
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (!onlyIfCheap) {
            int count = 0;
            try (IEnumerator e = this.source.enumerator();){
                while (e.moveNext()) {
                    this.selector.apply(e.current());
                    count = Math.addExact(count, 1);
                }
            }
            return count;
        }
        return this.source._getCount(onlyIfCheap);
    }
}

