/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.function.Func2;
import com.bestvike.function.IndexFunc2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.SelectManyIterator;
import com.bestvike.linq.enumerable.SelectManyIterator2;
import com.bestvike.linq.enumerable.SelectManyResultIterator;
import com.bestvike.linq.enumerable.SelectManyResultIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class SelectMany {
    private SelectMany() {
    }

    public static <TSource, TResult> IEnumerable<TResult> selectMany(IEnumerable<TSource> source, Func1<TSource, IEnumerable<TResult>> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        return new SelectManyIterator<TSource, TResult>(source, selector);
    }

    public static <TSource, TResult> IEnumerable<TResult> selectMany(IEnumerable<TSource> source, IndexFunc2<TSource, IEnumerable<TResult>> selector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (selector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.selector);
        }
        return new SelectManyIterator2<TSource, TResult>(source, selector);
    }

    public static <TSource, TCollection, TResult> IEnumerable<TResult> selectMany(IEnumerable<TSource> source, Func1<TSource, IEnumerable<TCollection>> collectionSelector, Func2<TSource, TCollection, TResult> resultSelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (collectionSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.collectionSelector);
        }
        if (resultSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.resultSelector);
        }
        return new SelectManyResultIterator<TSource, TCollection, TResult>(source, collectionSelector, resultSelector);
    }

    public static <TSource, TCollection, TResult> IEnumerable<TResult> selectMany(IEnumerable<TSource> source, IndexFunc2<TSource, IEnumerable<TCollection>> collectionSelector, Func2<TSource, TCollection, TResult> resultSelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (collectionSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.collectionSelector);
        }
        if (resultSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.resultSelector);
        }
        return new SelectManyResultIterator2<TSource, TCollection, TResult>(source, collectionSelector, resultSelector);
    }
}

