/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {countForDebugger()}")
final class SelectRangeIterator<TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final int start;
    private final int end;
    private final Func1<Integer, TResult> selector;

    SelectRangeIterator(int start, int end, Func1<Integer, TResult> selector) {
        assert (start < end);
        assert (Integer.compareUnsigned(end - start, Integer.MAX_VALUE) <= 0);
        assert (selector != null);
        this.start = start;
        this.end = end;
        this.selector = selector;
    }

    private int countForDebugger() {
        return this.end - this.start;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectRangeIterator<TResult>(this.start, this.end, this.selector);
    }

    @Override
    public boolean moveNext() {
        if (this.state < 1 || this.state == this.end - this.start + 1) {
            this.close();
            return false;
        }
        int index = this.state++ - 1;
        assert (this.start < this.end - index);
        this.current = this.selector.apply(this.start + index);
        return true;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectRangeIterator<TResult2>(this.start, this.end, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        TResult[] results = ArrayUtils.newInstance(clazz, this.end - this.start);
        int srcIndex = this.start;
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.selector.apply(srcIndex++);
        }
        return results;
    }

    @Override
    public Object[] _toArray() {
        Object[] results = new Object[this.end - this.start];
        int srcIndex = this.start;
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.selector.apply(srcIndex++);
        }
        return results;
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list = new ArrayList<TResult>(this.end - this.start);
        for (int i = this.start; i != this.end; ++i) {
            list.add(this.selector.apply(i));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (!onlyIfCheap) {
            for (int i = this.start; i != this.end; ++i) {
                this.selector.apply(i);
            }
        }
        return this.end - this.start;
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        return count >= this.end - this.start ? EmptyPartition.instance() : new SelectRangeIterator<TResult>(this.start + count, this.end, this.selector);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        return count >= this.end - this.start ? this : new SelectRangeIterator<TResult>(this.start, this.start + count, this.selector);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.end - this.start) < 0) {
            found.value = true;
            return this.selector.apply(this.start + index);
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        assert (this.end > this.start);
        found.value = true;
        return this.selector.apply(this.start);
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        assert (this.end > this.start);
        found.value = true;
        return this.selector.apply(this.end - 1);
    }
}

