/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {count}")
final class SelectRepeatIterator<TSource, TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final TSource element;
    private final int count;
    private final Func1<TSource, TResult> selector;

    SelectRepeatIterator(TSource element, int count, Func1<TSource, TResult> selector) {
        assert (count > 0);
        assert (selector != null);
        this.element = element;
        this.count = count;
        this.selector = selector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectRepeatIterator<TSource, TResult>(this.element, this.count, this.selector);
    }

    @Override
    public boolean moveNext() {
        if (this.state < 1 || this.state == this.count + 1) {
            this.close();
            return false;
        }
        ++this.state;
        this.current = this.selector.apply(this.element);
        return true;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectRepeatIterator<TSource, TResult2>(this.element, this.count, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        TResult[] results = ArrayUtils.newInstance(clazz, this.count);
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.selector.apply(this.element);
        }
        return results;
    }

    @Override
    public Object[] _toArray() {
        Object[] results = new Object[this.count];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.selector.apply(this.element);
        }
        return results;
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list = new ArrayList<TResult>(this.count);
        for (int i = 0; i < this.count; ++i) {
            list.add(this.selector.apply(this.element));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (!onlyIfCheap) {
            for (int i = 0; i < this.count; ++i) {
                this.selector.apply(this.element);
            }
        }
        return this.count;
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        return count >= this.count ? EmptyPartition.instance() : new SelectRepeatIterator<TSource, TResult>(this.element, this.count - count, this.selector);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        return count >= this.count ? this : new SelectRepeatIterator<TSource, TResult>(this.element, count, this.selector);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.count) < 0) {
            found.value = true;
            return this.selector.apply(this.element);
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        assert (this.count > 0);
        found.value = true;
        return this.selector.apply(this.element);
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        assert (this.count > 0);
        found.value = true;
        return this.selector.apply(this.element);
    }
}

