/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.EqualityComparer;
import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.util.ArrayUtils;
import java.util.ArrayList;
import java.util.List;

final class Set<TElement> {
    private final IEqualityComparer<TElement> comparer;
    private int[] buckets;
    private Slot[] slots;
    private int count;

    Set(IEqualityComparer<TElement> comparer) {
        this.comparer = comparer == null ? EqualityComparer.Default() : comparer;
        this.buckets = new int[7];
        this.slots = new Slot[7];
        for (int i = 0; i < 7; ++i) {
            this.slots[i] = new Slot();
        }
    }

    Set(IEnumerable<TElement> collection, IEqualityComparer<TElement> comparer) {
        this(comparer);
        this.unionWith(collection);
    }

    public boolean add(TElement value) {
        int hashCode = this.internalGetHashCode(value);
        int i = this.buckets[hashCode % this.buckets.length] - 1;
        while (i >= 0) {
            if (this.slots[i].hashCode == hashCode && this.comparer.equals(this.slots[i].value, value)) {
                return false;
            }
            i = this.slots[i].next;
        }
        if (this.count == this.slots.length) {
            this.resize();
        }
        int index = this.count++;
        int bucket = hashCode % this.buckets.length;
        this.slots[index].hashCode = hashCode;
        this.slots[index].value = value;
        this.slots[index].next = this.buckets[bucket] - 1;
        this.buckets[bucket] = index + 1;
        return true;
    }

    public boolean remove(TElement value) {
        int hashCode = this.internalGetHashCode(value);
        int bucket = hashCode % this.buckets.length;
        int last = -1;
        int i = this.buckets[bucket] - 1;
        while (i >= 0) {
            if (this.slots[i].hashCode == hashCode && this.comparer.equals(this.slots[i].value, value)) {
                if (last < 0) {
                    this.buckets[bucket] = this.slots[i].next + 1;
                } else {
                    this.slots[last].next = this.slots[i].next;
                }
                this.slots[i].hashCode = -1;
                this.slots[i].value = null;
                this.slots[i].next = -1;
                return true;
            }
            last = i;
            i = this.slots[i].next;
        }
        return false;
    }

    private void resize() {
        int i;
        int newSize = Math.addExact(Math.multiplyExact(this.count, 2), 1);
        int[] newBuckets = new int[newSize];
        Slot[] newSlots = new Slot[newSize];
        System.arraycopy(this.slots, 0, newSlots, 0, this.count);
        for (i = this.count; i < newSize; ++i) {
            newSlots[i] = new Slot();
        }
        for (i = 0; i < this.count; ++i) {
            int bucket = newSlots[i].hashCode % newSize;
            newSlots[i].next = newBuckets[bucket] - 1;
            newBuckets[bucket] = i + 1;
        }
        this.buckets = newBuckets;
        this.slots = newSlots;
    }

    public TElement[] toArray(Class<TElement> clazz) {
        TElement[] array = ArrayUtils.newInstance(clazz, this.count);
        for (int i = 0; i != array.length; ++i) {
            array[i] = this.slots[i].value;
        }
        return array;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.count];
        for (int i = 0; i != array.length; ++i) {
            array[i] = this.slots[i].value;
        }
        return array;
    }

    public List<TElement> toList() {
        int count = this.count;
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; i != count; ++i) {
            list.add(this.slots[i].value);
        }
        return list;
    }

    public int getCount() {
        return this.count;
    }

    public void unionWith(IEnumerable<TElement> other) {
        assert (other != null);
        try (IEnumerator<TElement> e = other.enumerator();){
            while (e.moveNext()) {
                this.add(e.current());
            }
        }
    }

    private int internalGetHashCode(TElement value) {
        return value == null ? 0 : this.comparer.hashCode(value) & Integer.MAX_VALUE;
    }

    private final class Slot {
        private int hashCode;
        private int next;
        private TElement value;

        private Slot() {
        }
    }
}

