/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.out;

public final class Single {
    private Single() {
    }

    public static <TSource> TSource single(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        TSource single = Single.tryGetSingle(source, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoElementsException();
        }
        return single;
    }

    public static <TSource> TSource single(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        TSource single = Single.tryGetSingle(source, predicate, foundRef);
        if (!((Boolean)foundRef.value).booleanValue()) {
            ThrowHelper.throwNoElementsException();
        }
        return single;
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source) {
        out<Boolean> foundRef = out.init();
        return Single.tryGetSingle(source, foundRef);
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source, TSource defaultValue) {
        out<Boolean> foundRef = out.init();
        TSource single = Single.tryGetSingle(source, foundRef);
        return (Boolean)foundRef.value != false ? single : defaultValue;
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        out<Boolean> foundRef = out.init();
        return Single.tryGetSingle(source, predicate, foundRef);
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate, TSource defaultValue) {
        out<Boolean> foundRef = out.init();
        TSource single = Single.tryGetSingle(source, predicate, foundRef);
        return (Boolean)foundRef.value != false ? single : defaultValue;
    }

    private static <TSource> TSource tryGetSingle(IEnumerable<TSource> source, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            switch (list._getCount()) {
                case 0: {
                    found.value = false;
                    return null;
                }
                case 1: {
                    found.value = true;
                    return (TSource)list.get(0);
                }
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (!e.moveNext()) {
                    found.value = false;
                    TSource TSource = null;
                    return TSource;
                }
                TSource result = e.current();
                if (!e.moveNext()) {
                    found.value = true;
                    TSource TSource = result;
                    return TSource;
                }
            }
        }
        found.value = false;
        ThrowHelper.throwMoreThanOneElementException();
        return null;
    }

    private static <TSource> TSource tryGetSingle(IEnumerable<TSource> source, Predicate1<TSource> predicate, out<Boolean> found) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource result = e.current();
                if (!predicate.apply(result)) continue;
                while (e.moveNext()) {
                    if (!predicate.apply(e.current())) continue;
                    ThrowHelper.throwMoreThanOneMatchException();
                }
                found.value = true;
                TSource TSource = result;
                return TSource;
            }
        }
        found.value = false;
        return null;
    }
}

