/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Array;

final class SingleLinkedNode<TSource> {
    private final TSource item;
    private final SingleLinkedNode<TSource> linked;

    SingleLinkedNode(TSource item) {
        this.linked = null;
        this.item = item;
    }

    private SingleLinkedNode(SingleLinkedNode<TSource> linked, TSource item) {
        assert (linked != null);
        this.linked = linked;
        this.item = item;
    }

    public TSource getItem() {
        return this.item;
    }

    public SingleLinkedNode<TSource> getLinked() {
        return this.linked;
    }

    public SingleLinkedNode<TSource> add(TSource item) {
        return new SingleLinkedNode<TSource>(this, item);
    }

    public int getCount() {
        int count = 0;
        SingleLinkedNode<TSource> node = this;
        while (node != null) {
            ++count;
            node = node.linked;
        }
        return count;
    }

    public SingleLinkedNode<TSource> getNode(int index) {
        assert (index >= 0 && index < this.getCount());
        SingleLinkedNode<TSource> node = this;
        while (index > 0) {
            node = node.linked;
            assert (node != null);
            --index;
        }
        return node;
    }

    public Array<TSource> toArray(int count) {
        assert (count == this.getCount());
        Object[] array = new Object[count];
        int index = count;
        SingleLinkedNode<TSource> node = this;
        while (node != null) {
            array[--index] = node.item;
            node = node.linked;
        }
        assert (index == 0);
        return new Array(array);
    }
}

