/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Array;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.adapter.enumerable.SingletonEnumerable;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator0;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator1;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator2;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator3;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIteratorN;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator0;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator1;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator2;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator3;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIteratorN;
import com.bestvike.linq.enumerable.StringKeepEmptySplitIterator1;
import com.bestvike.linq.enumerable.StringKeepEmptySplitIteratorN;
import com.bestvike.linq.enumerable.StringOmitEmptySplitIterator1;
import com.bestvike.linq.enumerable.StringOmitEmptySplitIteratorN;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.StringSplitOptions;
import com.bestvike.linq.util.Strings;
import com.bestvike.linq.util.lang.IStringSpan;
import com.bestvike.linq.util.lang.StringSpan;

public final class Split {
    private Split() {
    }

    public static IEnumerable<String> split(CharSequence source, char separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, char separator, StringSplitOptions options) {
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        if (source == null) {
            return Array.empty();
        }
        boolean omitEmptyEntries = options.hasFlag(StringSplitOptions.RemoveEmptyEntries);
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        IStringSpan candidate = StringSpan.asSpan(source);
        boolean trimEntries = options.hasFlag(StringSplitOptions.TrimEntries);
        return omitEmptyEntries ? new CharOmitEmptySplitIterator1(candidate, separator, trimEntries) : new CharKeepEmptySplitIterator1(candidate, separator, trimEntries);
    }

    public static IEnumerable<String> split(CharSequence source, char[] separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, char[] separator, StringSplitOptions options) {
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        if (source == null) {
            return Array.empty();
        }
        boolean omitEmptyEntries = options.hasFlag(StringSplitOptions.RemoveEmptyEntries);
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        if (separator == null || separator.length == 0) {
            return omitEmptyEntries ? new CharOmitEmptySplitIterator0(source) : new CharKeepEmptySplitIterator0(source);
        }
        IStringSpan candidate = StringSpan.asSpan(source);
        boolean trimEntries = options.hasFlag(StringSplitOptions.TrimEntries);
        switch (separator.length) {
            case 1: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator1(candidate, separator[0], trimEntries) : new CharKeepEmptySplitIterator1(candidate, separator[0], trimEntries);
            }
            case 2: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator2(candidate, separator[0], separator[1], trimEntries) : new CharKeepEmptySplitIterator2(candidate, separator[0], separator[1], trimEntries);
            }
            case 3: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator3(candidate, separator[0], separator[1], separator[2], trimEntries) : new CharKeepEmptySplitIterator3(candidate, separator[0], separator[1], separator[2], trimEntries);
            }
        }
        return omitEmptyEntries ? new CharOmitEmptySplitIteratorN(candidate, separator, trimEntries) : new CharKeepEmptySplitIteratorN(candidate, separator, trimEntries);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence separator, StringSplitOptions options) {
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        if (source == null) {
            return Array.empty();
        }
        boolean omitEmptyEntries = options.hasFlag(StringSplitOptions.RemoveEmptyEntries);
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        IStringSpan candidate = StringSpan.asSpan(source);
        boolean trimEntries = options.hasFlag(StringSplitOptions.TrimEntries);
        if (Strings.isNullOrEmpty(separator)) {
            if (trimEntries) {
                candidate = candidate.trim();
            }
            return omitEmptyEntries && candidate.length() == 0 ? Array.empty() : new SingletonEnumerable<String>(candidate.toString());
        }
        return omitEmptyEntries ? new StringOmitEmptySplitIterator1(candidate, separator, trimEntries) : new StringKeepEmptySplitIterator1(candidate, separator, trimEntries);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence[] separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence[] separator, StringSplitOptions options) {
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        if (source == null) {
            return Array.empty();
        }
        boolean omitEmptyEntries = options.hasFlag(StringSplitOptions.RemoveEmptyEntries);
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        if (separator == null || separator.length == 0) {
            return omitEmptyEntries ? new CharOmitEmptySplitIterator0(source) : new CharKeepEmptySplitIterator0(source);
        }
        IStringSpan candidate = StringSpan.asSpan(source);
        boolean trimEntries = options.hasFlag(StringSplitOptions.TrimEntries);
        return omitEmptyEntries ? new StringOmitEmptySplitIteratorN(candidate, separator, trimEntries) : new StringKeepEmptySplitIteratorN(candidate, separator, trimEntries);
    }
}

