/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;
import com.bestvike.linq.util.lang.IStringSpan;

final class StringOmitEmptySplitIterator1
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final CharSequence separator;
    private final boolean trimEntries;

    StringOmitEmptySplitIterator1(IStringSpan source, CharSequence separator, boolean trimEntries) {
        assert (!Strings.isNullOrEmpty(source));
        assert (!Strings.isNullOrEmpty(separator));
        this.source = source;
        this.separator = separator;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringOmitEmptySplitIterator1(this.source, this.separator, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        int length = this.source.length();
        char firstSepChar = this.separator.charAt(0);
        int currentSepLength = this.separator.length();
        while (index < length) {
            char tail;
            char head = this.source.charAt(index);
            if (head == firstSepChar && currentSepLength <= length - index && (currentSepLength == 1 || SplitInternal.sequenceEqual(this.source, index + 1, this.separator, 1, currentSepLength - 1))) {
                index += currentSepLength;
                continue;
            }
            int beginIndex = index++;
            while (index < length && ((tail = this.source.charAt(index)) != firstSepChar || currentSepLength > length - index || currentSepLength != 1 && !SplitInternal.sequenceEqual(this.source, index + 1, this.separator, 1, currentSepLength - 1))) {
                ++index;
            }
            IStringSpan span = this.source.subSequence(beginIndex, index);
            if (this.trimEntries && (span = span.trim()).length() == 0) {
                ++index;
                continue;
            }
            this.current = span.toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

