/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;
import com.bestvike.linq.util.lang.IStringSpan;

final class StringOmitEmptySplitIteratorN
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final CharSequence[] separators;
    private final boolean trimEntries;

    StringOmitEmptySplitIteratorN(IStringSpan source, CharSequence[] separators, boolean trimEntries) {
        assert (!Strings.isNullOrEmpty(source));
        assert (separators != null && separators.length > 0);
        this.source = source;
        this.separators = separators;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringOmitEmptySplitIteratorN(this.source, this.separators, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        int length = this.source.length();
        block0: while (index < length) {
            char head = this.source.charAt(index);
            for (CharSequence separator : this.separators) {
                if (Strings.isNullOrEmpty(separator)) continue;
                int currentSepLength = separator.length();
                if (head != separator.charAt(0) || currentSepLength > length - index || currentSepLength != 1 && !SplitInternal.sequenceEqual(this.source, index + 1, separator, 1, currentSepLength - 1)) continue;
                index += currentSepLength;
                continue block0;
            }
            int beginIndex = index++;
            block2: while (index < length) {
                char tail = this.source.charAt(index);
                for (CharSequence separator : this.separators) {
                    if (Strings.isNullOrEmpty(separator)) continue;
                    int currentSepLength = separator.length();
                    if (tail == separator.charAt(0) && currentSepLength <= length - index && (currentSepLength == 1 || SplitInternal.sequenceEqual(this.source, index + 1, separator, 1, currentSepLength - 1))) break block2;
                }
                ++index;
            }
            IStringSpan span = this.source.subSequence(beginIndex, index);
            if (this.trimEntries && (span = span.trim()).length() == 0) {
                ++index;
                continue;
            }
            this.current = span.toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

