/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.Index;
import com.bestvike.Range;
import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.IndexPredicate2;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.EnumerablePartition;
import com.bestvike.linq.enumerable.IListPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.ListPartition;
import com.bestvike.linq.enumerable.TakeRangeFromEndIterator;
import com.bestvike.linq.enumerable.TakeWhileIterator;
import com.bestvike.linq.enumerable.TakeWhileIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Take {
    private Take() {
    }

    public static <TSource> IEnumerable<TSource> take(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return count <= 0 ? EmptyPartition.instance() : Take.takeIterator(source, count);
    }

    public static <TSource> IEnumerable<TSource> take(IEnumerable<TSource> source, Range range) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (range == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.range);
        }
        Index start = range.getStart();
        Index end = range.getEnd();
        boolean isStartIndexFromEnd = start.isFromEnd();
        boolean isEndIndexFromEnd = end.isFromEnd();
        int startIndex = start.getValue();
        int endIndex = end.getValue();
        assert (startIndex >= 0);
        assert (endIndex >= 0);
        if (isStartIndexFromEnd) {
            if (startIndex == 0 || isEndIndexFromEnd && endIndex >= startIndex) {
                return EmptyPartition.instance();
            }
        } else if (!isEndIndexFromEnd) {
            return startIndex >= endIndex ? EmptyPartition.instance() : Take.takeRangeIterator(source, startIndex, endIndex);
        }
        return new TakeRangeFromEndIterator<TSource>(source, isStartIndexFromEnd, startIndex, isEndIndexFromEnd, endIndex);
    }

    public static <TSource> IEnumerable<TSource> takeWhile(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new TakeWhileIterator<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> takeWhile(IEnumerable<TSource> source, IndexPredicate2<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new TakeWhileIterator2<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> takeLast(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return count <= 0 ? EmptyPartition.instance() : new TakeRangeFromEndIterator<TSource>(source, true, count, true, 0);
    }

    static <TSource> IEnumerable<TSource> takeIterator(IEnumerable<TSource> source, int count) {
        assert (source != null);
        assert (count > 0);
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return partition._take(count);
        }
        if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                return new ListPartition(sourceList, 0, count - 1);
            }
            IList sourceList = (IList)source;
            return new IListPartition(sourceList, 0, count - 1);
        }
        return new EnumerablePartition<TSource>(source, 0, count - 1);
    }

    static <TSource> IEnumerable<TSource> takeRangeIterator(IEnumerable<TSource> source, int startIndex, int endIndex) {
        assert (source != null);
        assert (startIndex >= 0 && startIndex < endIndex);
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return Take.takePartitionRange(partition, startIndex, endIndex);
        }
        if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                return new ListPartition(sourceList, startIndex, endIndex - 1);
            }
            IList sourceList = (IList)source;
            return new IListPartition(sourceList, startIndex, endIndex - 1);
        }
        return new EnumerablePartition<TSource>(source, startIndex, endIndex - 1);
    }

    static <TSource> IPartition<TSource> takePartitionRange(IPartition<TSource> partition, int startIndex, int endIndex) {
        partition = endIndex == 0 ? EmptyPartition.instance() : partition._take(endIndex);
        return startIndex == 0 ? partition : partition._skip(startIndex);
    }
}

