/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Queue;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.Count;
import com.bestvike.linq.enumerable.Take;
import com.bestvike.out;

final class TakeRangeFromEndIterator<TSource>
extends AbstractIterator<TSource> {
    private final IEnumerable<TSource> source;
    private final boolean isStartIndexFromEnd;
    private final int startIndex;
    private final boolean isEndIndexFromEnd;
    private final int endIndex;
    private IEnumerator<TSource> enumerator;
    private Queue<TSource> queue;
    private int startIndexCalculated;
    private int endIndexCalculated;

    TakeRangeFromEndIterator(IEnumerable<TSource> source, boolean isStartIndexFromEnd, int startIndex, boolean isEndIndexFromEnd, int endIndex) {
        this.source = source;
        this.isStartIndexFromEnd = isStartIndexFromEnd;
        this.startIndex = startIndex;
        this.isEndIndexFromEnd = isEndIndexFromEnd;
        this.endIndex = endIndex;
    }

    private static int calculateStartIndex(boolean isStartIndexFromEnd, int startIndex, int count) {
        return Math.max(0, isStartIndexFromEnd ? count - startIndex : startIndex);
    }

    private static int calculateEndIndex(boolean isEndIndexFromEnd, int endIndex, int count) {
        return Math.min(count, isEndIndexFromEnd ? count - endIndex : endIndex);
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new TakeRangeFromEndIterator<TSource>(this.source, this.isStartIndexFromEnd, this.startIndex, this.isEndIndexFromEnd, this.endIndex);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean moveNext() {
        block18: while (true) {
            switch (this.state) {
                case 1: {
                    if (!TakeRangeFromEndIterator.$assertionsDisabled && this.source == null) {
                        throw new AssertionError();
                    }
                    if (!(TakeRangeFromEndIterator.$assertionsDisabled || this.isStartIndexFromEnd || this.isEndIndexFromEnd)) {
                        throw new AssertionError();
                    }
                    if (!TakeRangeFromEndIterator.$assertionsDisabled && !(this.isStartIndexFromEnd == false ? this.startIndex >= 0 && (this.isEndIndexFromEnd != false || this.startIndex < this.endIndex) : this.startIndex > 0 && (this.isEndIndexFromEnd == false || this.startIndex > this.endIndex))) {
                        throw new AssertionError();
                    }
                    countRef = out.init();
                    if (Count.tryGetNonEnumeratedCount(this.source, countRef)) {
                        startIndexCalculated = TakeRangeFromEndIterator.calculateStartIndex(this.isStartIndexFromEnd, this.startIndex, (Integer)countRef.value);
                        if (startIndexCalculated < (endIndexCalculated = TakeRangeFromEndIterator.calculateEndIndex(this.isEndIndexFromEnd, this.endIndex, (Integer)countRef.value))) {
                            this.enumerator = Take.takeRangeIterator(this.source, startIndexCalculated, endIndexCalculated).enumerator();
                            this.state = 2;
                            continue block18;
                        }
                        this.close();
                        return false;
                    }
                    if (!this.isStartIndexFromEnd) ** GOTO lbl64
                    e = this.source.enumerator();
                    var4_5 = null;
                    try {
                        if (!e.moveNext()) {
                            this.close();
                            var5_7 = false;
                            return var5_7;
                        }
                        this.queue = new Queue<T>();
                        this.queue.enqueue(e.current());
                        count = 1;
                        while (e.moveNext()) {
                            if (count < this.startIndex) {
                                this.queue.enqueue(e.current());
                                ++count;
                                continue;
                            }
                            do {
                                this.queue.dequeue();
                                this.queue.enqueue(e.current());
                                count = Math.addExact(count, 1);
                            } while (e.moveNext());
                        }
                        if (!TakeRangeFromEndIterator.$assertionsDisabled && this.queue.size() != Math.min(count, this.startIndex)) {
                            throw new AssertionError();
                        }
                    }
                    catch (Throwable var5_8) {
                        var4_5 = var5_8;
                        throw var5_8;
                    }
                    finally {
                        if (e != null) {
                            if (var4_5 != null) {
                                try {
                                    e.close();
                                }
                                catch (Throwable var6_9) {
                                    var4_5.addSuppressed(var6_9);
                                }
                            } else {
                                e.close();
                            }
                        }
                    }
                    this.startIndexCalculated = TakeRangeFromEndIterator.calculateStartIndex(true, this.startIndex, count);
                    this.endIndexCalculated = TakeRangeFromEndIterator.calculateEndIndex(this.isEndIndexFromEnd, this.endIndex, count);
                    if (!TakeRangeFromEndIterator.$assertionsDisabled && this.endIndexCalculated - this.startIndexCalculated > this.queue.size()) {
                        throw new AssertionError();
                    }
                    this.state = 3;
                    continue block18;
lbl64:
                    // 1 sources

                    if (!(TakeRangeFromEndIterator.$assertionsDisabled || !this.isStartIndexFromEnd && this.isEndIndexFromEnd)) {
                        throw new AssertionError();
                    }
                    this.enumerator = this.source.enumerator();
                    for (count = 0; count < this.startIndex && this.enumerator.moveNext(); ++count) {
                    }
                    if (count != this.startIndex) {
                        this.close();
                        return false;
                    }
                    this.queue = new Queue<T>();
                    while (this.enumerator.moveNext()) {
                        if (this.queue.size() != this.endIndex) {
                            this.queue.enqueue(this.enumerator.current());
                            continue;
                        }
                        this.queue.enqueue(this.enumerator.current());
                        this.current = this.queue.dequeue();
                        this.state = 4;
                        return true;
                    }
                    this.close();
                    return false;
                }
                case 2: {
                    if (this.enumerator.moveNext()) {
                        this.current = this.enumerator.current();
                        return true;
                    }
                    this.close();
                    return false;
                }
                case 3: {
                    if (this.startIndexCalculated < this.endIndexCalculated) {
                        ++this.startIndexCalculated;
                        this.current = this.queue.dequeue();
                        return true;
                    }
                    this.close();
                    return false;
                }
                case 4: {
                    if (this.enumerator.moveNext()) {
                        this.queue.enqueue(this.enumerator.current());
                        this.current = this.queue.dequeue();
                        return true;
                    }
                    this.close();
                    return false;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
        this.startIndexCalculated = 0;
        this.endIndexCalculated = 0;
        super.close();
    }
}

