/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.Spliterator;
import java.util.Spliterators;

public final class ToSpliterator {
    private ToSpliterator() {
    }

    public static <TSource> Spliterator<TSource> spliterator(IEnumerable<TSource> source) {
        IIListProvider listProv;
        int count;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof ICollection) {
            if (source instanceof IArray) {
                IArray array = (IArray)source;
                Object arr = array.getArray();
                Class<?> componentType = arr.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    if (componentType == Integer.TYPE) {
                        return Spliterators.spliterator((int[])arr, array._getStartIndex(), array._getEndIndex(), 1024);
                    }
                    if (componentType == Long.TYPE) {
                        return Spliterators.spliterator((long[])arr, array._getStartIndex(), array._getEndIndex(), 1024);
                    }
                    if (componentType == Double.TYPE) {
                        return Spliterators.spliterator((double[])arr, array._getStartIndex(), array._getEndIndex(), 1024);
                    }
                    return Spliterators.spliterator(array._toArray(), array._getStartIndex(), array._getEndIndex(), 1024);
                }
                return Spliterators.spliterator((Object[])arr, array._getStartIndex(), array._getEndIndex(), 1024);
            }
            ICollection collection = (ICollection)source;
            return Spliterators.spliterator(collection.getCollection(), 1024);
        }
        if (source instanceof IIListProvider && (count = (listProv = (IIListProvider)source)._getCount(true)) != -1) {
            return Spliterators.spliterator(source.enumerator(), (long)count, 1024);
        }
        return Spliterators.spliteratorUnknownSize(source.enumerator(), 1024);
    }
}

