/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.UnionByIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class UnionBy {
    private UnionBy() {
    }

    public static <TSource, TKey> IEnumerable<TSource> unionBy(IEnumerable<TSource> first, IEnumerable<TSource> second, Func1<TSource, TKey> keySelector) {
        return UnionBy.unionBy(first, second, keySelector, null);
    }

    public static <TSource, TKey> IEnumerable<TSource> unionBy(IEnumerable<TSource> first, IEnumerable<TSource> second, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        return new UnionByIterator<TSource, TKey>(first, second, keySelector, comparer);
    }
}

