/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.Set;
import java.util.List;

abstract class UnionIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    final IEqualityComparer<TSource> comparer;
    private IEnumerator<TSource> enumerator;
    private Set<TSource> set;

    UnionIterator(IEqualityComparer<TSource> comparer) {
        this.comparer = comparer;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.set = null;
        }
        super.close();
    }

    abstract IEnumerable<TSource> getEnumerable(int var1);

    abstract UnionIterator<TSource> _union(IEnumerable<TSource> var1);

    private void setEnumerator(IEnumerator<TSource> enumerator) {
        if (this.enumerator != null) {
            this.enumerator.close();
        }
        this.enumerator = enumerator;
    }

    private void storeFirst() {
        Set<TSource> set = new Set<TSource>(this.comparer);
        TSource element = this.enumerator.current();
        set.add(element);
        this.current = element;
        this.set = set;
    }

    private boolean getNext() {
        Set<TSource> set = this.set;
        assert (set != null);
        while (this.enumerator.moveNext()) {
            TSource element = this.enumerator.current();
            if (!set.add(element)) continue;
            this.current = element;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveNext() {
        if (this.state == 1) {
            IEnumerable<TSource> enumerable = this.getEnumerable(0);
            while (enumerable != null) {
                IEnumerator<TSource> enumerator = enumerable.enumerator();
                this.setEnumerator(enumerator);
                ++this.state;
                if (enumerator.moveNext()) {
                    this.storeFirst();
                    return true;
                }
                enumerable = this.getEnumerable(this.state - 1);
            }
        } else if (this.state > 0) {
            while (true) {
                if (this.getNext()) {
                    return true;
                }
                IEnumerable<TSource> enumerable = this.getEnumerable(this.state - 1);
                if (enumerable == null) break;
                this.setEnumerator(enumerable.enumerator());
                ++this.state;
            }
        }
        this.close();
        return false;
    }

    private Set<TSource> fillSet() {
        Set<TSource> set = new Set<TSource>(this.comparer);
        int index = 0;
        IEnumerable<TSource> enumerable;
        while ((enumerable = this.getEnumerable(index)) != null) {
            set.unionWith(enumerable);
            ++index;
        }
        return set;
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        return this.fillSet().toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        return this.fillSet().toArray();
    }

    @Override
    public List<TSource> _toList() {
        return this.fillSet().toList();
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return onlyIfCheap ? -1 : this.fillSet().getCount();
    }
}

