/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.enumerable.UnionIterator;
import com.bestvike.linq.enumerable.UnionIteratorN;

final class UnionIterator2<TSource>
extends UnionIterator<TSource> {
    private final IEnumerable<TSource> first;
    private final IEnumerable<TSource> second;

    UnionIterator2(IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer) {
        super(comparer);
        assert (first != null);
        assert (second != null);
        this.first = first;
        this.second = second;
    }

    @Override
    public Iterator<TSource> clone() {
        return new UnionIterator2<TSource>(this.first, this.second, this.comparer);
    }

    @Override
    IEnumerable<TSource> getEnumerable(int index) {
        assert (index >= 0 && index <= 2);
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        return null;
    }

    @Override
    UnionIterator<TSource> _union(IEnumerable<TSource> next) {
        SingleLinkedNode<IEnumerable<TSource>> sources = new SingleLinkedNode<IEnumerable<IEnumerable<TSource>>>(this.first).add(this.second).add(next);
        return new UnionIteratorN<TSource>(sources, 2, this.comparer);
    }
}

