/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.enumerable.UnionIterator;
import com.bestvike.linq.enumerable.UnionIterator2;

final class UnionIteratorN<TSource>
extends UnionIterator<TSource> {
    private final SingleLinkedNode<IEnumerable<TSource>> sources;
    private final int headIndex;

    UnionIteratorN(SingleLinkedNode<IEnumerable<TSource>> sources, int headIndex, IEqualityComparer<TSource> comparer) {
        super(comparer);
        assert (headIndex >= 2);
        assert (sources != null && sources.getCount() == headIndex + 1);
        this.sources = sources;
        this.headIndex = headIndex;
    }

    @Override
    public Iterator<TSource> clone() {
        return new UnionIteratorN<TSource>(this.sources, this.headIndex, this.comparer);
    }

    @Override
    IEnumerable<TSource> getEnumerable(int index) {
        return index > this.headIndex ? null : this.sources.getNode(this.headIndex - index).getItem();
    }

    @Override
    UnionIterator<TSource> _union(IEnumerable<TSource> next) {
        if (this.headIndex == 0x7FFFFFFD) {
            return new UnionIterator2<TSource>(this, next, this.comparer);
        }
        return new UnionIteratorN<TSource>(this.sources.add(next), this.headIndex + 1, this.comparer);
    }
}

