/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.WhereSelectArrayIterator;
import com.bestvike.linq.util.Utilities;
import java.util.ArrayList;
import java.util.List;

final class WhereArrayIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    private final IArray<TSource> source;
    private final Predicate1<TSource> predicate;

    WhereArrayIterator(IArray<TSource> source, Predicate1<TSource> predicate) {
        assert (source != null && source._getCount() > 0);
        assert (predicate != null);
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Iterator<TSource> clone() {
        return new WhereArrayIterator<TSource>(this.source, this.predicate);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        while (Integer.compareUnsigned(index, this.source._getCount()) < 0) {
            Object item = this.source.get(index);
            ++this.state;
            if (!this.predicate.apply(item)) continue;
            this.current = item;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<TSource, TResult> selector) {
        return new WhereSelectArrayIterator<TSource, TResult>(this.source, this.predicate, selector);
    }

    @Override
    public IEnumerable<TSource> _where(Predicate1<TSource> predicate) {
        return new WhereArrayIterator<TSource>(this.source, Utilities.combinePredicates(this.predicate, predicate));
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        int count = this.source._getCount();
        LargeArrayBuilder<Object> builder = new LargeArrayBuilder<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(item);
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        int count = this.source._getCount();
        LargeArrayBuilder builder = new LargeArrayBuilder(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(item);
        }
        return builder.toArray();
    }

    @Override
    public List<TSource> _toList() {
        ArrayList list = new ArrayList();
        int count = this.source._getCount();
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            list.add(item);
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        int length = this.source._getCount();
        for (int i = 0; i < length; ++i) {
            if (!this.predicate.apply(this.source.get(i))) continue;
            count = Math.addExact(count, 1);
        }
        return count;
    }
}

