/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.WhereSelectEnumerableIterator;
import com.bestvike.linq.util.Utilities;
import java.util.ArrayList;
import java.util.List;

final class WhereEnumerableIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    private final IEnumerable<TSource> source;
    private final Predicate1<TSource> predicate;
    private IEnumerator<TSource> enumerator;

    WhereEnumerableIterator(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        assert (source != null);
        assert (predicate != null);
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Iterator<TSource> clone() {
        return new WhereEnumerableIterator<TSource>(this.source, this.predicate);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource item = this.enumerator.current();
                    if (!this.predicate.apply(item)) continue;
                    this.current = item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<TSource, TResult> selector) {
        return new WhereSelectEnumerableIterator<TSource, TResult>(this.source, this.predicate, selector);
    }

    @Override
    public IEnumerable<TSource> _where(Predicate1<TSource> predicate) {
        return new WhereEnumerableIterator<TSource>(this.source, Utilities.combinePredicates(this.predicate, predicate));
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                builder.add(item);
            }
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                builder.add(item);
            }
        }
        return builder.toArray();
    }

    @Override
    public List<TSource> _toList() {
        ArrayList<TSource> list = new ArrayList<TSource>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                list.add(item);
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                if (!this.predicate.apply(e.current())) continue;
                count = Math.addExact(count, 1);
            }
        }
        return count;
    }
}

