/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ZipIterator;
import com.bestvike.linq.enumerable.ZipIterator2;
import com.bestvike.linq.enumerable.ZipIterator3;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.tuple.Tuple2;
import com.bestvike.tuple.Tuple3;

public final class Zip {
    private Zip() {
    }

    public static <TFirst, TSecond, TResult> IEnumerable<TResult> zip(IEnumerable<TFirst> first, IEnumerable<TSecond> second, Func2<TFirst, TSecond, TResult> resultSelector) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (resultSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.resultSelector);
        }
        return new ZipIterator<TFirst, TSecond, TResult>(first, second, resultSelector);
    }

    public static <TFirst, TSecond> IEnumerable<Tuple2<TFirst, TSecond>> zip(IEnumerable<TFirst> first, IEnumerable<TSecond> second) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        return new ZipIterator2<TFirst, TSecond>(first, second);
    }

    public static <TFirst, TSecond, TThird> IEnumerable<Tuple3<TFirst, TSecond, TThird>> zip(IEnumerable<TFirst> first, IEnumerable<TSecond> second, IEnumerable<TThird> third) {
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (third == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.third);
        }
        return new ZipIterator3<TFirst, TSecond, TThird>(first, second, third);
    }
}

