/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.tuple.Tuple2;

final class ZipIterator2<TFirst, TSecond>
extends AbstractIterator<Tuple2<TFirst, TSecond>> {
    private final IEnumerable<TFirst> first;
    private final IEnumerable<TSecond> second;
    private IEnumerator<TFirst> firstEnumerator;
    private IEnumerator<TSecond> secondEnumerator;

    ZipIterator2(IEnumerable<TFirst> first, IEnumerable<TSecond> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public AbstractIterator<Tuple2<TFirst, TSecond>> clone() {
        return new ZipIterator2<TFirst, TSecond>(this.first, this.second);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.firstEnumerator = this.first.enumerator();
                this.secondEnumerator = this.second.enumerator();
                this.state = 2;
            }
            case 2: {
                if (this.firstEnumerator.moveNext() && this.secondEnumerator.moveNext()) {
                    this.current = new Tuple2<TFirst, TSecond>(this.firstEnumerator.current(), this.secondEnumerator.current());
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.firstEnumerator != null) {
            this.firstEnumerator.close();
            this.firstEnumerator = null;
        }
        if (this.secondEnumerator != null) {
            this.secondEnumerator.close();
            this.secondEnumerator = null;
        }
        super.close();
    }
}

