/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.tuple.Tuple3;

final class ZipIterator3<TFirst, TSecond, TThird>
extends AbstractIterator<Tuple3<TFirst, TSecond, TThird>> {
    private final IEnumerable<TFirst> first;
    private final IEnumerable<TSecond> second;
    private final IEnumerable<TThird> third;
    private IEnumerator<TFirst> firstEnumerator;
    private IEnumerator<TSecond> secondEnumerator;
    private IEnumerator<TThird> thirdEnumerator;

    ZipIterator3(IEnumerable<TFirst> first, IEnumerable<TSecond> second, IEnumerable<TThird> third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public AbstractIterator<Tuple3<TFirst, TSecond, TThird>> clone() {
        return new ZipIterator3<TFirst, TSecond, TThird>(this.first, this.second, this.third);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.firstEnumerator = this.first.enumerator();
                this.secondEnumerator = this.second.enumerator();
                this.thirdEnumerator = this.third.enumerator();
                this.state = 2;
            }
            case 2: {
                if (this.firstEnumerator.moveNext() && this.secondEnumerator.moveNext() && this.thirdEnumerator.moveNext()) {
                    this.current = new Tuple3<TFirst, TSecond, TThird>(this.firstEnumerator.current(), this.secondEnumerator.current(), this.thirdEnumerator.current());
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.firstEnumerator != null) {
            this.firstEnumerator.close();
            this.firstEnumerator = null;
        }
        if (this.secondEnumerator != null) {
            this.secondEnumerator.close();
            this.secondEnumerator = null;
        }
        if (this.thirdEnumerator != null) {
            this.thirdEnumerator.close();
            this.thirdEnumerator = null;
        }
        super.close();
    }
}

