/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.exception;

import com.bestvike.linq.util.Environment;
import com.bestvike.linq.util.Strings;

public class ArgumentException
extends RuntimeException {
    private String paramName;

    public ArgumentException() {
        super("Value does not fall within the expected range.");
    }

    public ArgumentException(String message) {
        super(message);
    }

    public ArgumentException(String message, Exception innerException) {
        super(message, innerException);
    }

    public ArgumentException(String message, String paramName, Exception innerException) {
        super(message, innerException);
        this.paramName = paramName;
    }

    public ArgumentException(String message, String paramName) {
        super(message);
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getMessage() {
        String s = super.getMessage();
        if (s == null) {
            s = "Value does not fall within the expected range.";
        }
        if (!Strings.isNullOrEmpty(this.paramName)) {
            s = s + Environment.NewLine + String.format("Parameter name: %s.", this.paramName);
        }
        return s;
    }
}

