/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.util.lang;

import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.lang.IStringSpan;
import com.bestvike.linq.util.lang.StringEmptySpan;
import com.bestvike.linq.util.lang.StringSubSpan;

public final class StringSpan
implements IStringSpan {
    public static final StringEmptySpan Empty = new StringEmptySpan();
    private final CharSequence value;

    StringSpan(CharSequence value) {
        this.value = value;
    }

    public static IStringSpan asSpan(CharSequence value) {
        if (value == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.value);
        }
        return value.length() == 0 ? Empty : new StringSpan(value);
    }

    public static IStringSpan asSpan(CharSequence value, int startIndex) {
        if (value == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.value);
        }
        return StringSpan.asSpan(value, startIndex, value.length() - startIndex);
    }

    public static IStringSpan asSpan(CharSequence value, int startIndex, int length) {
        int valueLength;
        if (value == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.value);
        }
        if (startIndex < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.startIndex);
        }
        if (startIndex > (valueLength = value.length())) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.startIndex);
        }
        if (length < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.length);
        }
        if (startIndex > valueLength - length) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.length);
        }
        if (length == 0) {
            return Empty;
        }
        if (startIndex == 0 && length == valueLength) {
            return new StringSpan(value);
        }
        return new StringSubSpan(value, startIndex, length);
    }

    @Override
    public CharSequence raw() {
        return this.value;
    }

    @Override
    public int offset() {
        return 0;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public IStringSpan trim() {
        int end;
        int start;
        CharSequence value = this.value;
        int length = value.length();
        for (start = 0; start < length && Character.isWhitespace(value.charAt(start)); ++start) {
        }
        for (end = length - 1; end >= start && Character.isWhitespace(value.charAt(end)); --end) {
        }
        int len = end - start + 1;
        return len == length ? this : (len == 0 ? Empty : new StringSubSpan(this, start, len));
    }

    @Override
    public IStringSpan subSequence(int start) {
        return this.subSequence(start, this.value.length());
    }

    @Override
    public IStringSpan subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int length = this.value.length();
        if (end > length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        int subLen = end - start;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return start == 0 && end == length ? this : new StringSubSpan(this.value, start, subLen);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof IStringSpan)) {
            return false;
        }
        IStringSpan thatSpan = (IStringSpan)that;
        int n = this.length();
        if (n != thatSpan.length()) {
            return false;
        }
        int i = 0;
        while (n-- != 0) {
            if (this.charAt(i) != thatSpan.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            result = 31 * result + this.charAt(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

